/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core;

final class IntervalFunctionCompanion {
    private IntervalFunctionCompanion() {
    }

    static double randomize(double current, double randomizationFactor) {
        double delta = randomizationFactor * current;
        double min2 = current - delta;
        double max = current + delta;
        return min2 + Math.random() * (max - min2 + 1.0);
    }

    static void checkInterval(long interval) {
        if (interval < 1L) {
            throw new IllegalArgumentException("Illegal argument interval: " + interval + " millis is less than 1");
        }
    }

    static void checkMultiplier(double multiplier) {
        if (multiplier < 1.0) {
            throw new IllegalArgumentException("Illegal argument multiplier: " + multiplier);
        }
    }

    static void checkRandomizationFactor(double randomizationFactor) {
        if (randomizationFactor < 0.0 || randomizationFactor >= 1.0) {
            throw new IllegalArgumentException("Illegal argument randomizationFactor: " + randomizationFactor);
        }
    }

    static void checkAttempt(long attempt) {
        if (attempt < 1L) {
            throw new IllegalArgumentException("Illegal argument attempt: " + attempt);
        }
    }
}

