/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.internal;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.ResultRecordedAsFailureException;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnCallNotPermittedEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnErrorEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnFailureRateExceededEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnIgnoredErrorEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnResetEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnSlowCallRateExceededEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnStateTransitionEvent;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerOnSuccessEvent;
import io.github.resilience4j.circuitbreaker.internal.CircuitBreakerMetrics;
import io.github.resilience4j.circuitbreaker.internal.SchedulerFactory;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.EventProcessor;
import io.github.resilience4j.core.lang.Nullable;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CircuitBreakerStateMachine
implements CircuitBreaker {
    private static final Logger LOG = LoggerFactory.getLogger(CircuitBreakerStateMachine.class);
    private final String name;
    private final AtomicReference<CircuitBreakerState> stateReference;
    private final CircuitBreakerConfig circuitBreakerConfig;
    private final Map<String, String> tags;
    private final CircuitBreakerEventProcessor eventProcessor;
    private final Clock clock;
    private final SchedulerFactory schedulerFactory;
    private final Function<Clock, Long> currentTimestampFunction;
    private final TimeUnit timestampUnit;

    private CircuitBreakerStateMachine(String name, CircuitBreakerConfig circuitBreakerConfig, Clock clock, SchedulerFactory schedulerFactory, Map<String, String> tags) {
        this.name = name;
        this.circuitBreakerConfig = Objects.requireNonNull(circuitBreakerConfig, "Config must not be null");
        this.eventProcessor = new CircuitBreakerEventProcessor();
        this.clock = clock;
        this.stateReference = new AtomicReference<ClosedState>(new ClosedState());
        this.schedulerFactory = schedulerFactory;
        this.tags = Objects.requireNonNull(tags, "Tags must not be null");
        this.currentTimestampFunction = circuitBreakerConfig.getCurrentTimestampFunction();
        this.timestampUnit = circuitBreakerConfig.getTimestampUnit();
    }

    public CircuitBreakerStateMachine(String name, CircuitBreakerConfig circuitBreakerConfig, SchedulerFactory schedulerFactory) {
        this(name, circuitBreakerConfig, Clock.systemUTC(), schedulerFactory, HashMap.empty());
    }

    public CircuitBreakerStateMachine(String name, CircuitBreakerConfig circuitBreakerConfig, Clock clock) {
        this(name, circuitBreakerConfig, clock, SchedulerFactory.getInstance(), HashMap.empty());
    }

    public CircuitBreakerStateMachine(String name, CircuitBreakerConfig circuitBreakerConfig, Clock clock, Map<String, String> tags) {
        this(name, circuitBreakerConfig, clock, SchedulerFactory.getInstance(), tags);
    }

    public CircuitBreakerStateMachine(String name, CircuitBreakerConfig circuitBreakerConfig) {
        this(name, circuitBreakerConfig, Clock.systemUTC());
    }

    public CircuitBreakerStateMachine(String name, CircuitBreakerConfig circuitBreakerConfig, Map<String, String> tags) {
        this(name, circuitBreakerConfig, Clock.systemUTC(), tags);
    }

    public CircuitBreakerStateMachine(String name) {
        this(name, CircuitBreakerConfig.ofDefaults());
    }

    public CircuitBreakerStateMachine(String name, Supplier<CircuitBreakerConfig> circuitBreakerConfig) {
        this(name, circuitBreakerConfig.get());
    }

    public CircuitBreakerStateMachine(String name, Supplier<CircuitBreakerConfig> circuitBreakerConfig, Map<String, String> tags) {
        this(name, circuitBreakerConfig.get(), tags);
    }

    @Override
    public long getCurrentTimestamp() {
        return this.currentTimestampFunction.apply(this.clock);
    }

    @Override
    public TimeUnit getTimestampUnit() {
        return this.timestampUnit;
    }

    @Override
    public boolean tryAcquirePermission() {
        boolean callPermitted = this.stateReference.get().tryAcquirePermission();
        if (!callPermitted) {
            this.publishCallNotPermittedEvent();
        }
        return callPermitted;
    }

    @Override
    public void releasePermission() {
        this.stateReference.get().releasePermission();
    }

    @Override
    public void acquirePermission() {
        try {
            this.stateReference.get().acquirePermission();
        }
        catch (Exception e) {
            this.publishCallNotPermittedEvent();
            throw e;
        }
    }

    @Override
    public void onError(long duration, TimeUnit durationUnit, Throwable throwable) {
        if (throwable instanceof CompletionException || throwable instanceof ExecutionException) {
            Throwable cause = throwable.getCause();
            this.handleThrowable(duration, durationUnit, cause);
        } else {
            this.handleThrowable(duration, durationUnit, throwable);
        }
    }

    private void handleThrowable(long duration, TimeUnit durationUnit, Throwable throwable) {
        if (this.circuitBreakerConfig.getIgnoreExceptionPredicate().test(throwable)) {
            LOG.debug("CircuitBreaker '{}' ignored an exception:", (Object)this.name, (Object)throwable);
            this.releasePermission();
            this.publishCircuitIgnoredErrorEvent(this.name, duration, durationUnit, throwable);
        } else if (this.circuitBreakerConfig.getRecordExceptionPredicate().test(throwable)) {
            LOG.debug("CircuitBreaker '{}' recorded an exception as failure:", (Object)this.name, (Object)throwable);
            this.publishCircuitErrorEvent(this.name, duration, durationUnit, throwable);
            this.stateReference.get().onError(duration, durationUnit, throwable);
        } else {
            LOG.debug("CircuitBreaker '{}' recorded an exception as success:", (Object)this.name, (Object)throwable);
            this.publishSuccessEvent(duration, durationUnit);
            this.stateReference.get().onSuccess(duration, durationUnit);
        }
    }

    @Override
    public void onSuccess(long duration, TimeUnit durationUnit) {
        LOG.debug("CircuitBreaker '{}' succeeded:", (Object)this.name);
        this.publishSuccessEvent(duration, durationUnit);
        this.stateReference.get().onSuccess(duration, durationUnit);
    }

    @Override
    public void onResult(long duration, TimeUnit durationUnit, @Nullable Object result) {
        if (result != null && this.circuitBreakerConfig.getRecordResultPredicate().test(result)) {
            LOG.debug("CircuitBreaker '{}' recorded a result type '{}' as failure:", (Object)this.name, (Object)result.getClass());
            ResultRecordedAsFailureException failure = new ResultRecordedAsFailureException(this.name, result);
            this.publishCircuitErrorEvent(this.name, duration, durationUnit, failure);
            this.stateReference.get().onError(duration, durationUnit, failure);
        } else {
            this.onSuccess(duration, durationUnit);
        }
    }

    @Override
    public CircuitBreaker.State getState() {
        return this.stateReference.get().getState();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CircuitBreakerConfig getCircuitBreakerConfig() {
        return this.circuitBreakerConfig;
    }

    @Override
    public CircuitBreaker.Metrics getMetrics() {
        return this.stateReference.get().getMetrics();
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    public String toString() {
        return String.format("CircuitBreaker '%s'", this.name);
    }

    @Override
    public void reset() {
        CircuitBreakerState previousState = this.stateReference.getAndUpdate(currentState -> new ClosedState());
        if (previousState.getState() != CircuitBreaker.State.CLOSED) {
            this.publishStateTransitionEvent(CircuitBreaker.StateTransition.transitionBetween(this.getName(), previousState.getState(), CircuitBreaker.State.CLOSED));
        }
        this.publishResetEvent();
    }

    private void stateTransition(CircuitBreaker.State newState, UnaryOperator<CircuitBreakerState> newStateGenerator) {
        CircuitBreakerState previousState = this.stateReference.getAndUpdate(currentState -> {
            CircuitBreaker.StateTransition.transitionBetween(this.getName(), currentState.getState(), newState);
            currentState.preTransitionHook();
            return (CircuitBreakerState)newStateGenerator.apply((CircuitBreakerState)currentState);
        });
        this.publishStateTransitionEvent(CircuitBreaker.StateTransition.transitionBetween(this.getName(), previousState.getState(), newState));
    }

    @Override
    public void transitionToDisabledState() {
        this.stateTransition(CircuitBreaker.State.DISABLED, currentState -> new DisabledState());
    }

    @Override
    public void transitionToMetricsOnlyState() {
        this.stateTransition(CircuitBreaker.State.METRICS_ONLY, currentState -> new MetricsOnlyState());
    }

    @Override
    public void transitionToForcedOpenState() {
        this.stateTransition(CircuitBreaker.State.FORCED_OPEN, currentState -> new ForcedOpenState(currentState.attempts() + 1));
    }

    @Override
    public void transitionToClosedState() {
        this.stateTransition(CircuitBreaker.State.CLOSED, currentState -> new ClosedState());
    }

    @Override
    public void transitionToOpenState() {
        this.stateTransition(CircuitBreaker.State.OPEN, currentState -> new OpenState(currentState.attempts() + 1, currentState.getMetrics()));
    }

    @Override
    public void transitionToHalfOpenState() {
        this.stateTransition(CircuitBreaker.State.HALF_OPEN, currentState -> new HalfOpenState(currentState.attempts()));
    }

    private boolean shouldPublishEvents(CircuitBreakerEvent event) {
        return this.stateReference.get().shouldPublishEvents(event);
    }

    private void publishEventIfPossible(CircuitBreakerEvent event) {
        if (this.shouldPublishEvents(event)) {
            if (this.eventProcessor.hasConsumers()) {
                try {
                    this.eventProcessor.consumeEvent(event);
                    LOG.debug("Event {} published: {}", (Object)event.getEventType(), (Object)event);
                }
                catch (Throwable t) {
                    LOG.warn("Failed to handle event {}", (Object)event.getEventType(), (Object)t);
                }
            } else {
                LOG.debug("No Consumers: Event {} not published", (Object)event.getEventType());
            }
        } else {
            LOG.debug("Publishing not allowed: Event {} not published", (Object)event.getEventType());
        }
    }

    private void publishStateTransitionEvent(CircuitBreaker.StateTransition stateTransition) {
        if (CircuitBreaker.StateTransition.isInternalTransition(stateTransition)) {
            return;
        }
        CircuitBreakerOnStateTransitionEvent event = new CircuitBreakerOnStateTransitionEvent(this.name, stateTransition);
        this.publishEventIfPossible(event);
    }

    private void publishResetEvent() {
        CircuitBreakerOnResetEvent event = new CircuitBreakerOnResetEvent(this.name);
        this.publishEventIfPossible(event);
    }

    private void publishCallNotPermittedEvent() {
        CircuitBreakerOnCallNotPermittedEvent event = new CircuitBreakerOnCallNotPermittedEvent(this.name);
        this.publishEventIfPossible(event);
    }

    private void publishSuccessEvent(long duration, TimeUnit durationUnit) {
        CircuitBreakerOnSuccessEvent event = new CircuitBreakerOnSuccessEvent(this.name, Duration.ofNanos(durationUnit.toNanos(duration)));
        this.publishEventIfPossible(event);
    }

    private void publishCircuitErrorEvent(String name, long duration, TimeUnit durationUnit, Throwable throwable) {
        CircuitBreakerOnErrorEvent event = new CircuitBreakerOnErrorEvent(name, Duration.ofNanos(durationUnit.toNanos(duration)), throwable);
        this.publishEventIfPossible(event);
    }

    private void publishCircuitIgnoredErrorEvent(String name, long duration, TimeUnit durationUnit, Throwable throwable) {
        CircuitBreakerOnIgnoredErrorEvent event = new CircuitBreakerOnIgnoredErrorEvent(name, Duration.ofNanos(durationUnit.toNanos(duration)), throwable);
        this.publishEventIfPossible(event);
    }

    private void publishCircuitFailureRateExceededEvent(String name, float failureRate) {
        CircuitBreakerOnFailureRateExceededEvent event = new CircuitBreakerOnFailureRateExceededEvent(name, failureRate);
        this.publishEventIfPossible(event);
    }

    private void publishCircuitSlowCallRateExceededEvent(String name, float slowCallRate) {
        CircuitBreakerOnSlowCallRateExceededEvent event = new CircuitBreakerOnSlowCallRateExceededEvent(name, slowCallRate);
        this.publishEventIfPossible(event);
    }

    private void publishCircuitThresholdsExceededEvent(CircuitBreakerMetrics.Result result, CircuitBreakerMetrics metrics) {
        if (CircuitBreakerMetrics.Result.hasFailureRateExceededThreshold(result)) {
            this.publishCircuitFailureRateExceededEvent(this.getName(), metrics.getFailureRate());
        }
        if (CircuitBreakerMetrics.Result.hasSlowCallRateExceededThreshold(result)) {
            this.publishCircuitSlowCallRateExceededEvent(this.getName(), metrics.getSlowCallRate());
        }
    }

    @Override
    public CircuitBreaker.EventPublisher getEventPublisher() {
        return this.eventProcessor;
    }

    private class HalfOpenState
    implements CircuitBreakerState {
        private final AtomicInteger permittedNumberOfCalls;
        private final AtomicBoolean isHalfOpen;
        private final int attempts;
        private final CircuitBreakerMetrics circuitBreakerMetrics;
        @Nullable
        private final ScheduledFuture<?> transitionToOpenFuture;

        HalfOpenState(int attempts) {
            int permittedNumberOfCallsInHalfOpenState = CircuitBreakerStateMachine.this.circuitBreakerConfig.getPermittedNumberOfCallsInHalfOpenState();
            this.circuitBreakerMetrics = CircuitBreakerMetrics.forHalfOpen(permittedNumberOfCallsInHalfOpenState, CircuitBreakerStateMachine.this.getCircuitBreakerConfig(), CircuitBreakerStateMachine.this.clock);
            this.permittedNumberOfCalls = new AtomicInteger(permittedNumberOfCallsInHalfOpenState);
            this.isHalfOpen = new AtomicBoolean(true);
            this.attempts = attempts;
            long maxWaitDurationInHalfOpenState = CircuitBreakerStateMachine.this.circuitBreakerConfig.getMaxWaitDurationInHalfOpenState().toMillis();
            if (maxWaitDurationInHalfOpenState >= 1L) {
                ScheduledExecutorService scheduledExecutorService = CircuitBreakerStateMachine.this.schedulerFactory.getScheduler();
                this.transitionToOpenFuture = scheduledExecutorService.schedule(this::toOpenState, maxWaitDurationInHalfOpenState, TimeUnit.MILLISECONDS);
            } else {
                this.transitionToOpenFuture = null;
            }
        }

        @Override
        public boolean tryAcquirePermission() {
            if (this.permittedNumberOfCalls.getAndUpdate(current -> current == 0 ? current : --current) > 0) {
                return true;
            }
            this.circuitBreakerMetrics.onCallNotPermitted();
            return false;
        }

        @Override
        public void acquirePermission() {
            if (!this.tryAcquirePermission()) {
                throw CallNotPermittedException.createCallNotPermittedException(CircuitBreakerStateMachine.this);
            }
        }

        @Override
        public void preTransitionHook() {
            this.cancelAutomaticTransitionToOpen();
        }

        private void cancelAutomaticTransitionToOpen() {
            if (this.transitionToOpenFuture != null && !this.transitionToOpenFuture.isDone()) {
                this.transitionToOpenFuture.cancel(true);
            }
        }

        private void toOpenState() {
            if (this.isHalfOpen.compareAndSet(true, false)) {
                CircuitBreakerStateMachine.this.transitionToOpenState();
            }
        }

        @Override
        public void releasePermission() {
            this.permittedNumberOfCalls.incrementAndGet();
        }

        @Override
        public void onError(long duration, TimeUnit durationUnit, Throwable throwable) {
            this.checkIfThresholdsExceeded(this.circuitBreakerMetrics.onError(duration, durationUnit));
        }

        @Override
        public void onSuccess(long duration, TimeUnit durationUnit) {
            this.checkIfThresholdsExceeded(this.circuitBreakerMetrics.onSuccess(duration, durationUnit));
        }

        @Override
        public int attempts() {
            return this.attempts;
        }

        private void checkIfThresholdsExceeded(CircuitBreakerMetrics.Result result) {
            if (CircuitBreakerMetrics.Result.hasExceededThresholds(result) && this.isHalfOpen.compareAndSet(true, false)) {
                CircuitBreakerStateMachine.this.transitionToOpenState();
            }
            if (result == CircuitBreakerMetrics.Result.BELOW_THRESHOLDS && this.isHalfOpen.compareAndSet(true, false)) {
                CircuitBreakerStateMachine.this.transitionToClosedState();
            }
        }

        @Override
        public CircuitBreaker.State getState() {
            return CircuitBreaker.State.HALF_OPEN;
        }

        @Override
        public CircuitBreakerMetrics getMetrics() {
            return this.circuitBreakerMetrics;
        }
    }

    private class ForcedOpenState
    implements CircuitBreakerState {
        private final CircuitBreakerMetrics circuitBreakerMetrics;
        private final int attempts;

        ForcedOpenState(int attempts) {
            this.attempts = attempts;
            this.circuitBreakerMetrics = CircuitBreakerMetrics.forForcedOpen(CircuitBreakerStateMachine.this.circuitBreakerConfig, CircuitBreakerStateMachine.this.clock);
        }

        @Override
        public boolean tryAcquirePermission() {
            this.circuitBreakerMetrics.onCallNotPermitted();
            return false;
        }

        @Override
        public void acquirePermission() {
            this.circuitBreakerMetrics.onCallNotPermitted();
            throw CallNotPermittedException.createCallNotPermittedException(CircuitBreakerStateMachine.this);
        }

        @Override
        public void releasePermission() {
        }

        @Override
        public void onError(long duration, TimeUnit durationUnit, Throwable throwable) {
        }

        @Override
        public void onSuccess(long duration, TimeUnit durationUnit) {
        }

        @Override
        public int attempts() {
            return this.attempts;
        }

        @Override
        public CircuitBreaker.State getState() {
            return CircuitBreaker.State.FORCED_OPEN;
        }

        @Override
        public CircuitBreakerMetrics getMetrics() {
            return this.circuitBreakerMetrics;
        }
    }

    private class MetricsOnlyState
    implements CircuitBreakerState {
        private final CircuitBreakerMetrics circuitBreakerMetrics;
        private final AtomicBoolean isFailureRateExceeded;
        private final AtomicBoolean isSlowCallRateExceeded;

        MetricsOnlyState() {
            this.circuitBreakerMetrics = CircuitBreakerMetrics.forMetricsOnly(CircuitBreakerStateMachine.this.getCircuitBreakerConfig(), CircuitBreakerStateMachine.this.clock);
            this.isFailureRateExceeded = new AtomicBoolean(false);
            this.isSlowCallRateExceeded = new AtomicBoolean(false);
        }

        @Override
        public boolean tryAcquirePermission() {
            return true;
        }

        @Override
        public void acquirePermission() {
        }

        @Override
        public void releasePermission() {
        }

        @Override
        public void onError(long duration, TimeUnit durationUnit, Throwable throwable) {
            this.checkIfThresholdsExceeded(this.circuitBreakerMetrics.onError(duration, durationUnit));
        }

        @Override
        public void onSuccess(long duration, TimeUnit durationUnit) {
            this.checkIfThresholdsExceeded(this.circuitBreakerMetrics.onSuccess(duration, durationUnit));
        }

        private void checkIfThresholdsExceeded(CircuitBreakerMetrics.Result result) {
            if (!CircuitBreakerMetrics.Result.hasExceededThresholds(result)) {
                return;
            }
            if (this.shouldPublishFailureRateExceededEvent(result)) {
                CircuitBreakerStateMachine.this.publishCircuitThresholdsExceededEvent(result, this.circuitBreakerMetrics);
            }
            if (this.shouldPublishSlowCallRateExceededEvent(result)) {
                CircuitBreakerStateMachine.this.publishCircuitThresholdsExceededEvent(result, this.circuitBreakerMetrics);
            }
        }

        private boolean shouldPublishFailureRateExceededEvent(CircuitBreakerMetrics.Result result) {
            return CircuitBreakerMetrics.Result.hasFailureRateExceededThreshold(result) && this.isFailureRateExceeded.compareAndSet(false, true);
        }

        private boolean shouldPublishSlowCallRateExceededEvent(CircuitBreakerMetrics.Result result) {
            return CircuitBreakerMetrics.Result.hasSlowCallRateExceededThreshold(result) && this.isSlowCallRateExceeded.compareAndSet(false, true);
        }

        @Override
        public int attempts() {
            return 0;
        }

        @Override
        public CircuitBreaker.State getState() {
            return CircuitBreaker.State.METRICS_ONLY;
        }

        @Override
        public CircuitBreakerMetrics getMetrics() {
            return this.circuitBreakerMetrics;
        }
    }

    private class DisabledState
    implements CircuitBreakerState {
        private final CircuitBreakerMetrics circuitBreakerMetrics;

        DisabledState() {
            this.circuitBreakerMetrics = CircuitBreakerMetrics.forDisabled(CircuitBreakerStateMachine.this.getCircuitBreakerConfig(), CircuitBreakerStateMachine.this.clock);
        }

        @Override
        public boolean tryAcquirePermission() {
            return true;
        }

        @Override
        public void acquirePermission() {
        }

        @Override
        public void releasePermission() {
        }

        @Override
        public void onError(long duration, TimeUnit durationUnit, Throwable throwable) {
        }

        @Override
        public void onSuccess(long duration, TimeUnit durationUnit) {
        }

        @Override
        public int attempts() {
            return 0;
        }

        @Override
        public CircuitBreaker.State getState() {
            return CircuitBreaker.State.DISABLED;
        }

        @Override
        public CircuitBreakerMetrics getMetrics() {
            return this.circuitBreakerMetrics;
        }
    }

    private class OpenState
    implements CircuitBreakerState {
        private final int attempts;
        private final Instant retryAfterWaitDuration;
        private final CircuitBreakerMetrics circuitBreakerMetrics;
        private final AtomicBoolean isOpen;
        @Nullable
        private final ScheduledFuture<?> transitionToHalfOpenFuture;

        OpenState(int attempts, CircuitBreakerMetrics circuitBreakerMetrics) {
            this.attempts = attempts;
            long waitDurationInMillis = (Long)CircuitBreakerStateMachine.this.circuitBreakerConfig.getWaitIntervalFunctionInOpenState().apply(attempts);
            this.retryAfterWaitDuration = CircuitBreakerStateMachine.this.clock.instant().plus(waitDurationInMillis, ChronoUnit.MILLIS);
            this.circuitBreakerMetrics = circuitBreakerMetrics;
            if (CircuitBreakerStateMachine.this.circuitBreakerConfig.isAutomaticTransitionFromOpenToHalfOpenEnabled()) {
                ScheduledExecutorService scheduledExecutorService = CircuitBreakerStateMachine.this.schedulerFactory.getScheduler();
                this.transitionToHalfOpenFuture = scheduledExecutorService.schedule(this::toHalfOpenState, waitDurationInMillis, TimeUnit.MILLISECONDS);
            } else {
                this.transitionToHalfOpenFuture = null;
            }
            this.isOpen = new AtomicBoolean(true);
        }

        @Override
        public boolean tryAcquirePermission() {
            if (CircuitBreakerStateMachine.this.clock.instant().isAfter(this.retryAfterWaitDuration)) {
                this.toHalfOpenState();
                return true;
            }
            this.circuitBreakerMetrics.onCallNotPermitted();
            return false;
        }

        @Override
        public void acquirePermission() {
            if (!this.tryAcquirePermission()) {
                throw CallNotPermittedException.createCallNotPermittedException(CircuitBreakerStateMachine.this);
            }
        }

        @Override
        public void releasePermission() {
        }

        @Override
        public void onError(long duration, TimeUnit durationUnit, Throwable throwable) {
            this.circuitBreakerMetrics.onError(duration, durationUnit);
        }

        @Override
        public void onSuccess(long duration, TimeUnit durationUnit) {
            this.circuitBreakerMetrics.onSuccess(duration, durationUnit);
        }

        @Override
        public int attempts() {
            return this.attempts;
        }

        @Override
        public CircuitBreaker.State getState() {
            return CircuitBreaker.State.OPEN;
        }

        @Override
        public CircuitBreakerMetrics getMetrics() {
            return this.circuitBreakerMetrics;
        }

        @Override
        public void preTransitionHook() {
            this.cancelAutomaticTransitionToHalfOpen();
        }

        private void toHalfOpenState() {
            if (this.isOpen.compareAndSet(true, false)) {
                CircuitBreakerStateMachine.this.transitionToHalfOpenState();
            }
        }

        private void cancelAutomaticTransitionToHalfOpen() {
            if (this.transitionToHalfOpenFuture != null && !this.transitionToHalfOpenFuture.isDone()) {
                this.transitionToHalfOpenFuture.cancel(true);
            }
        }
    }

    private class ClosedState
    implements CircuitBreakerState {
        private final CircuitBreakerMetrics circuitBreakerMetrics;
        private final AtomicBoolean isClosed;

        ClosedState() {
            this.circuitBreakerMetrics = CircuitBreakerMetrics.forClosed(CircuitBreakerStateMachine.this.getCircuitBreakerConfig(), CircuitBreakerStateMachine.this.clock);
            this.isClosed = new AtomicBoolean(true);
        }

        @Override
        public boolean tryAcquirePermission() {
            return this.isClosed.get();
        }

        @Override
        public void acquirePermission() {
        }

        @Override
        public void releasePermission() {
        }

        @Override
        public void onError(long duration, TimeUnit durationUnit, Throwable throwable) {
            this.checkIfThresholdsExceeded(this.circuitBreakerMetrics.onError(duration, durationUnit));
        }

        @Override
        public void onSuccess(long duration, TimeUnit durationUnit) {
            this.checkIfThresholdsExceeded(this.circuitBreakerMetrics.onSuccess(duration, durationUnit));
        }

        @Override
        public int attempts() {
            return 0;
        }

        private void checkIfThresholdsExceeded(CircuitBreakerMetrics.Result result) {
            if (CircuitBreakerMetrics.Result.hasExceededThresholds(result) && this.isClosed.compareAndSet(true, false)) {
                CircuitBreakerStateMachine.this.publishCircuitThresholdsExceededEvent(result, this.circuitBreakerMetrics);
                CircuitBreakerStateMachine.this.transitionToOpenState();
            }
        }

        @Override
        public CircuitBreaker.State getState() {
            return CircuitBreaker.State.CLOSED;
        }

        @Override
        public CircuitBreakerMetrics getMetrics() {
            return this.circuitBreakerMetrics;
        }
    }

    private class CircuitBreakerEventProcessor
    extends EventProcessor<CircuitBreakerEvent>
    implements EventConsumer<CircuitBreakerEvent>,
    CircuitBreaker.EventPublisher {
        private CircuitBreakerEventProcessor() {
        }

        @Override
        public CircuitBreaker.EventPublisher onSuccess(EventConsumer<CircuitBreakerOnSuccessEvent> onSuccessEventConsumer) {
            this.registerConsumer(CircuitBreakerOnSuccessEvent.class.getSimpleName(), onSuccessEventConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onError(EventConsumer<CircuitBreakerOnErrorEvent> onErrorEventConsumer) {
            this.registerConsumer(CircuitBreakerOnErrorEvent.class.getSimpleName(), onErrorEventConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onStateTransition(EventConsumer<CircuitBreakerOnStateTransitionEvent> onStateTransitionEventConsumer) {
            this.registerConsumer(CircuitBreakerOnStateTransitionEvent.class.getSimpleName(), onStateTransitionEventConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onReset(EventConsumer<CircuitBreakerOnResetEvent> onResetEventConsumer) {
            this.registerConsumer(CircuitBreakerOnResetEvent.class.getSimpleName(), onResetEventConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onIgnoredError(EventConsumer<CircuitBreakerOnIgnoredErrorEvent> onIgnoredErrorEventConsumer) {
            this.registerConsumer(CircuitBreakerOnIgnoredErrorEvent.class.getSimpleName(), onIgnoredErrorEventConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onCallNotPermitted(EventConsumer<CircuitBreakerOnCallNotPermittedEvent> onCallNotPermittedEventConsumer) {
            this.registerConsumer(CircuitBreakerOnCallNotPermittedEvent.class.getSimpleName(), onCallNotPermittedEventConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onFailureRateExceeded(EventConsumer<CircuitBreakerOnFailureRateExceededEvent> onFailureRateExceededConsumer) {
            this.registerConsumer(CircuitBreakerOnFailureRateExceededEvent.class.getSimpleName(), onFailureRateExceededConsumer);
            return this;
        }

        @Override
        public CircuitBreaker.EventPublisher onSlowCallRateExceeded(EventConsumer<CircuitBreakerOnSlowCallRateExceededEvent> onSlowCallRateExceededConsumer) {
            this.registerConsumer(CircuitBreakerOnSlowCallRateExceededEvent.class.getSimpleName(), onSlowCallRateExceededConsumer);
            return this;
        }

        @Override
        public void consumeEvent(CircuitBreakerEvent event) {
            super.processEvent(event);
        }
    }

    private static interface CircuitBreakerState {
        public boolean tryAcquirePermission();

        public void acquirePermission();

        public void releasePermission();

        public void onError(long var1, TimeUnit var3, Throwable var4);

        public void onSuccess(long var1, TimeUnit var3);

        public int attempts();

        public CircuitBreaker.State getState();

        public CircuitBreakerMetrics getMetrics();

        default public boolean shouldPublishEvents(CircuitBreakerEvent event) {
            return event.getEventType().forcePublish || this.getState().allowPublish;
        }

        default public void preTransitionHook() {
        }
    }
}

