/*
 * Decompiled with CFR 0.152.
 */
package fr.welloznetwork.wellozlauncher.ui.frame.pages;

import fr.theshark34.openlauncherlib.util.Saver;
import fr.welloznetwork.wellozlauncher.WelloZLauncher;
import fr.welloznetwork.wellozlauncher.ui.PanelManager;
import fr.welloznetwork.wellozlauncher.ui.frame.Page;
import fr.welloznetwork.wellozlauncher.ui.frame.pages.PageDownload;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Font;
import oshi.SystemInfo;
import oshi.hardware.GlobalMemory;

public class PageSettings
extends Page {
    private GridPane settings = new GridPane();
    private Saver saver = WelloZLauncher.getInstance().getSaver();
    private Button backButton = new Button("Retour");
    private Button saveButton = new Button("Sauvegarder");
    private Label maxMemory = new Label("M\u00e9moire RAM");
    private ComboBox<String> comboBox = new ComboBox();

    @Override
    public void init(PanelManager panelManager) {
        super.init(panelManager);
        this.showSettings();
        this.showBackground();
        this.showRamSelector();
        this.showSaveButton();
        this.showBackButton();
        this.settings.getChildren().addAll((Object[])new Node[]{this.backButton, this.saveButton, this.maxMemory, this.comboBox});
    }

    private void showSettings() {
        this.getLayout().getStyleClass().add((Object)"layout");
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setMinWidth(800.0);
        columnConstraints.setMaxWidth(0.0);
        this.getLayout().getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints, new ColumnConstraints()});
        this.getLayout().add((Node)this.settings, 0, 0);
    }

    private void showBackground() {
        GridPane background = new GridPane();
        this.setCanTakeAllSize((Node)background);
        this.getLayout().add((Node)background, 1, 0);
        this.getLayout().getStyleClass().add((Object)"login");
    }

    private void showRamSelector() {
        this.maxMemory.setFont(Font.font((String)"Montserrat Alternates Bold", (double)18.0));
        this.setCanTakeAllSize((Node)this.maxMemory);
        this.setCenterV((Node)this.maxMemory);
        this.setCenterH((Node)this.maxMemory);
        this.maxMemory.setTranslateY(-140.0);
        SystemInfo systemInfo = new SystemInfo();
        GlobalMemory globalMemory = systemInfo.getHardware().getMemory();
        this.comboBox.getStyleClass().add((Object)"settings-memory");
        int i = 512;
        while ((double)i < Math.ceil((double)globalMemory.getTotal() / Math.pow(1024.0, 2.0))) {
            this.comboBox.getItems().add((Object)((double)i / 1024.0 + " " + "Go"));
            i += 512;
        }
        int memoryValue = 1024;
        try {
            if (this.saver.get("Xmx") == null) {
                throw new NumberFormatException();
            }
            memoryValue = Integer.parseInt(this.saver.get("Xmx"));
        }
        catch (NumberFormatException e) {
            this.saver.set("Xmx", String.valueOf(memoryValue));
            this.saver.save();
            WelloZLauncher.getInstance().getLogger().printStackTrace(e);
        }
        if (this.comboBox.getItems().contains((Object)((double)memoryValue / 1024.0 + " " + "Go"))) {
            this.comboBox.setValue((Object)((double)memoryValue / 1024.0 + " " + "Go"));
        } else {
            this.comboBox.setValue((Object)"1.0 Go");
        }
        this.setCanTakeAllSize((Node)this.comboBox);
        this.setCenterV((Node)this.comboBox);
        this.setCenterH((Node)this.comboBox);
        this.comboBox.setTranslateY(-100.0);
    }

    private void showSaveButton() {
        this.saveButton.setFont(Font.font((String)"Montserrat Alternates Regular", (double)13.0));
        this.setCanTakeAllSize((Node)this.saveButton);
        this.setCenterV((Node)this.saveButton);
        this.setCenterH((Node)this.saveButton);
        this.saveButton.setMaxWidth(105.0);
        this.saveButton.setMaxHeight(10.0);
        this.saveButton.setTranslateY(30.0);
        this.saveButton.getStyleClass().add((Object)"settings-button");
        this.saveButton.setOnMouseClicked(e -> {
            double memoryValue = Double.parseDouble(((String)this.comboBox.getValue()).replace("Go", ""));
            this.saver.set("Xmx", String.valueOf((int)(memoryValue *= 1024.0)));
            this.panelManager.showPanel(new PageDownload());
        });
    }

    private void showBackButton() {
        this.backButton.setFont(Font.font((String)"Montserrat Alternates Regular", (double)15.0));
        this.setCenterH((Node)this.backButton);
        this.setCanTakeAllSize((Node)this.backButton);
        this.setTop((Node)this.backButton);
        this.setRight((Node)this.backButton);
        this.backButton.setTranslateX(-20.0);
        this.backButton.setTranslateY(6.0);
        this.backButton.getStyleClass().add((Object)"settings-button");
        this.backButton.setOnMouseClicked(e -> this.panelManager.showPanel(new PageDownload()));
    }
}

