/*
 * Decompiled with CFR 0.152.
 */
package fr.welloznetwork.wellozlauncher.ui.frame.pages;

import fr.litarvan.openauth.microsoft.MicrosoftAuthenticator;
import fr.theshark34.openlauncherlib.minecraft.AuthInfos;
import fr.theshark34.openlauncherlib.util.Saver;
import fr.welloznetwork.wellozlauncher.WelloZLauncher;
import fr.welloznetwork.wellozlauncher.ui.PanelManager;
import fr.welloznetwork.wellozlauncher.ui.frame.Page;
import fr.welloznetwork.wellozlauncher.ui.frame.pages.PageDownload;
import fr.welloznetwork.wellozlauncher.util.LauncherUtil;
import java.awt.Desktop;
import java.net.URI;
import java.util.UUID;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Font;

public class PageHome
extends Page {
    private GridPane home = new GridPane();
    private GridPane background = new GridPane();
    private Saver saver = WelloZLauncher.getInstance().getSaver();
    private Button loginButton = new Button("SE CONNECTER AVEC MICROSOFT");
    private Button signUpButton = new Button("Cr\u00e9er un compte");
    private Button noMinecraftAccount = new Button("Je n'ai pas de compte Minecraft");
    private Label copyright = new Label("Copyright WelloZNetwork. Do not distribute!");

    @Override
    public void init(PanelManager panelManager) {
        super.init(panelManager);
        this.showLogin();
        this.showBackground();
        this.showCopyright();
        this.showLoginButton();
        this.showSignUpButton();
        this.showNoMinecraftAccountButton();
        this.home.getChildren().addAll((Object[])new Node[]{this.background, this.loginButton, this.signUpButton, this.copyright, this.noMinecraftAccount});
    }

    private void showLogin() {
        this.getLayout().getStyleClass().add((Object)"layout");
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setMinWidth(800.0);
        columnConstraints.setMaxWidth(0.0);
        this.getLayout().getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints, new ColumnConstraints()});
        this.getLayout().add((Node)this.home, 0, 0);
    }

    private void showBackground() {
        GridPane background = new GridPane();
        this.setCanTakeAllSize((Node)background);
        this.getLayout().add((Node)background, 1, 0);
        this.getLayout().getStyleClass().add((Object)"login");
        this.background.setMaxWidth(400.0);
        this.background.setMaxHeight(300.0);
        this.background.setTranslateX(200.0);
        this.background.setTranslateY(-20.0);
        this.background.getStyleClass().add((Object)"background");
    }

    private void showCopyright() {
        this.copyright.setFont(Font.font((String)"Montserrat Alternates Bold", (double)10.0));
        this.copyright.setTranslateX(-18.0);
        this.copyright.setTranslateY(-2.0);
        this.setCenterH((Node)this.copyright);
        this.setCanTakeAllSize((Node)this.copyright);
        this.setBottom((Node)this.copyright);
        this.setRight((Node)this.copyright);
        this.copyright.getStyleClass().add((Object)"copyright");
        this.copyright.setOnMouseClicked(e -> {
            try {
                Desktop.getDesktop().browse(new URI("https://welloznetwork.fr/"));
            }
            catch (Exception ex) {
                WelloZLauncher.getInstance().getLogger().printStackTrace(ex);
            }
        });
    }

    private void showLoginButton() {
        this.setCanTakeAllSize((Node)this.loginButton);
        this.setCenterV((Node)this.loginButton);
        this.setCenterH((Node)this.loginButton);
        this.loginButton.setMaxWidth(370.0);
        this.loginButton.setMaxHeight(70.0);
        this.loginButton.setTranslateY(-40.0);
        this.loginButton.getStyleClass().add((Object)"login-microsoft");
        this.loginButton.setOnMouseClicked(e -> this.authenticate());
    }

    private void showSignUpButton() {
        this.setCanTakeAllSize((Node)this.signUpButton);
        this.setCenterV((Node)this.signUpButton);
        this.setCenterH((Node)this.signUpButton);
        this.signUpButton.setMaxWidth(130.0);
        this.signUpButton.setMaxHeight(10.0);
        this.signUpButton.setTranslateY(30.0);
        this.signUpButton.getStyleClass().add((Object)"sign-up-button");
        this.signUpButton.setOnMouseClicked(e -> {
            try {
                Desktop.getDesktop().browse(new URI("https://login.live.com/oauth20_authorize.srf?redirect_uri=https%3a%2f%2fsisu.xboxlive.com%2fconnect%2foauth%2fXboxLive&response_type=code&state=LAAAAAEB26ACgZgcAm8n2WPbF381EecjMpviJszuMWOXhzCOr-xT_lrun7mPOjVjYzc0ZjFkMTBkZTQ0OTFhZDgyOTIzZjhjNjI3ODg1MyBkQmxrM0RReWcweVUrc0k5ZTlWWkJRLjABAA&client_id=000000004420578E&scope=XboxLive.Signin%20+XboxLive.offline_access&lw=1&fl=dob,easi2&xsup=1&uaid=a3734d6b57964808bfba50d635bfac05&signup=1&cobrandid=8058f65d-ce06-4c30-9559-473c9275a65d&nopa=2"));
            }
            catch (Exception ex) {
                WelloZLauncher.getInstance().getLogger().printStackTrace(ex);
            }
        });
    }

    private void showNoMinecraftAccountButton() {
        this.setCanTakeAllSize((Node)this.noMinecraftAccount);
        this.setCenterV((Node)this.noMinecraftAccount);
        this.setCenterH((Node)this.noMinecraftAccount);
        this.noMinecraftAccount.setMaxWidth(232.0);
        this.noMinecraftAccount.setMaxHeight(10.0);
        this.noMinecraftAccount.setTranslateY(110.0);
        this.noMinecraftAccount.getStyleClass().add((Object)"sign-up-button");
        this.noMinecraftAccount.setOnMouseClicked(e -> {
            TextInputDialog textInputDialog = new TextInputDialog("");
            textInputDialog.setTitle("Entrez votre nom d'utilisateur");
            textInputDialog.setHeaderText("");
            textInputDialog.showAndWait().ifPresent(username -> {
                if (!this.isValidUsername((String)username)) {
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("Erreur");
                    alert.setHeaderText("");
                    alert.setContentText("Le nom d'utilisateur ne peut pas \u00eatre vide, contenir des espaces ou des caract\u00e8res sp\u00e9ciaux.");
                    alert.showAndWait();
                    return;
                }
                new Thread(() -> {
                    boolean isRegisteredAccount = LauncherUtil.isRegisteredAccount(username);
                    Platform.runLater(() -> {
                        if (isRegisteredAccount) {
                            Alert alert = new Alert(Alert.AlertType.ERROR);
                            alert.setTitle("Erreur");
                            alert.setHeaderText("");
                            alert.setContentText("Ce nom d'utilisateur appartient d\u00e9j\u00e0 \u00e0 un compte Minecraft. Veuillez vous connectez avec votre compte Microsoft.");
                            alert.showAndWait();
                        } else {
                            this.authenticateWithoutMinecraftAccount((String)username);
                        }
                    });
                }).start();
            });
        });
    }

    private void authenticate() {
        MicrosoftAuthenticator microsoftAuthenticator = new MicrosoftAuthenticator();
        microsoftAuthenticator.loginWithAsyncWebview().whenComplete((response, error) -> {
            if (error != null) {
                WelloZLauncher.getInstance().getLogger().err(error.toString());
                Platform.runLater(() -> this.setAlert(Alert.AlertType.ERROR, "Error", error.getMessage(), null));
                return;
            }
            this.saver.set("accessToken", response.getAccessToken());
            this.saver.set("refreshToken", response.getRefreshToken());
            this.saver.save();
            WelloZLauncher.getInstance().setAuthInfos(new AuthInfos(response.getProfile().getName(), response.getAccessToken(), response.getProfile().getId(), response.getXuid(), response.getClientId()));
            Platform.runLater(() -> this.panelManager.showPanel(new PageDownload()));
        });
    }

    private void authenticateWithoutMinecraftAccount(String username) {
        this.saver.set("username", username);
        this.saver.set("accessToken", "token-" + username);
        this.saver.save();
        WelloZLauncher.getInstance().setAuthInfos(new AuthInfos(username, "token-" + username, UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes()).toString()));
        Platform.runLater(() -> this.panelManager.showPanel(new PageDownload()));
    }

    private boolean isValidUsername(String username) {
        if (username == null || username.trim().isEmpty()) {
            return false;
        }
        return username.matches("[A-Za-z0-9_-]+");
    }

    private void setAlert(Alert.AlertType alertType, String title, String headerText, String contentText) {
        Alert alert = new Alert(alertType);
        alert.setTitle(title);
        alert.setHeaderText(headerText);
        alert.setContentText(contentText);
        alert.show();
    }
}

