/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.language.core;

import fr.theshark34.openlauncherlib.configuration.api.ConfigurationManager;
import fr.theshark34.openlauncherlib.configuration.core.SimpleConfiguration;
import fr.theshark34.openlauncherlib.language.api.Language;
import fr.theshark34.openlauncherlib.language.api.LanguageInfo;
import fr.theshark34.openlauncherlib.language.api.LanguageManager;
import fr.theshark34.openlauncherlib.language.core.SimpleLanguage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultLanguageManager
extends LanguageManager {
    private final Map<String, Language> langMap = new HashMap<String, Language>();
    private final ConfigurationManager configurationManager;
    private Language defaultLanguage;

    public DefaultLanguageManager(Logger logger, ConfigurationManager configurationManager) {
        super(logger);
        this.configurationManager = configurationManager;
    }

    @Override
    public List<Language> getLanguages() {
        return new ArrayList<Language>(this.langMap.values());
    }

    @Override
    public Language getLanguage(LanguageInfo name) {
        return this.langMap.get(name.get().toLowerCase());
    }

    @Override
    public Language getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Override
    public boolean isDefaultLanguage(LanguageInfo name) {
        return this.defaultLanguage != null && this.defaultLanguage.getName().equalsIgnoreCase(name.get());
    }

    @Override
    public void setDefaultLanguage(Language language) {
        this.defaultLanguage = language;
    }

    @Override
    public void registerLanguage(LanguageInfo identify, LanguageInfo name, String path) {
        try {
            SimpleConfiguration configuration = new SimpleConfiguration(this.configurationManager.getLogger(), new BufferedReader(new InputStreamReader(Objects.requireNonNull(DefaultLanguageManager.class.getResourceAsStream(path + name.get() + ".json")), StandardCharsets.UTF_8)));
            if (!this.langMap.containsKey(name.get().toLowerCase())) {
                this.langMap.put(name.get().toLowerCase(), new SimpleLanguage(name, this, identify, configuration));
            } else {
                ((SimpleLanguage)this.langMap.get(name.get().toLowerCase())).registerLanguage(identify, configuration);
            }
        }
        catch (IOException e) {
            this.configurationManager.getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

