/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.versions;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowlogger.ILogger;
import fr.flowarg.flowstringer.StringUtils;
import fr.flowarg.flowupdater.FlowUpdater;
import fr.flowarg.flowupdater.download.DownloadList;
import fr.flowarg.flowupdater.download.ICurseFeaturesUser;
import fr.flowarg.flowupdater.download.IProgressCallback;
import fr.flowarg.flowupdater.download.Step;
import fr.flowarg.flowupdater.download.json.CurseFileInfo;
import fr.flowarg.flowupdater.download.json.CurseModPackInfo;
import fr.flowarg.flowupdater.download.json.Mod;
import fr.flowarg.flowupdater.integrations.curseforgeintegration.CurseMod;
import fr.flowarg.flowupdater.utils.IOUtils;
import fr.flowarg.flowupdater.utils.ModFileDeleter;
import fr.flowarg.flowupdater.utils.builderapi.BuilderArgument;
import fr.flowarg.flowupdater.utils.builderapi.BuilderException;
import fr.flowarg.flowupdater.utils.builderapi.IBuilder;
import fr.flowarg.flowupdater.versions.IModLoaderVersion;
import fr.flowarg.flowupdater.versions.VanillaVersion;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FabricVersion
implements ICurseFeaturesUser,
IModLoaderVersion {
    private final List<Mod> mods;
    private final String fabricVersion;
    private final List<CurseFileInfo> curseMods;
    private final ModFileDeleter fileDeleter;
    private List<CurseMod> allCurseMods;
    private final String installerVersion;
    private final CurseModPackInfo modPackInfo;
    private URL installerUrl;
    private ILogger logger;
    private VanillaVersion vanilla;
    private DownloadList downloadList;
    private IProgressCallback callback;

    private FabricVersion(List<Mod> mods, List<CurseFileInfo> curseMods, String fabricVersion, ModFileDeleter fileDeleter, CurseModPackInfo modPackInfo) {
        this.mods = mods;
        this.fileDeleter = fileDeleter;
        this.curseMods = curseMods;
        this.fabricVersion = fabricVersion;
        this.modPackInfo = modPackInfo;
        this.installerVersion = this.getLatestInstallerVersion();
    }

    @Nullable
    private static String getLatestFabricVersion() {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new URL("https://maven.fabricmc.net/net/fabricmc/fabric-loader/maven-metadata.xml").openStream());
            return FabricVersion.getLatestVersionOfArtifact(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    private String getLatestInstallerVersion() {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new URL("https://maven.fabricmc.net/net/fabricmc/fabric-installer/maven-metadata.xml").openStream());
            return FabricVersion.getLatestVersionOfArtifact(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getLatestVersionOfArtifact(@NotNull Document doc) {
        doc.getDocumentElement().normalize();
        Element root = doc.getDocumentElement();
        NodeList nList = root.getElementsByTagName("versioning");
        String version = "";
        for (int temp = 0; temp < nList.getLength(); ++temp) {
            Node node = nList.item(temp);
            if (node.getNodeType() != 1) continue;
            version = ((Element)node).getElementsByTagName("release").item(0).getTextContent();
        }
        return version;
    }

    @Override
    public boolean isModLoaderAlreadyInstalled(@NotNull Path installDir) {
        return Files.exists(installDir.resolve("libraries").resolve("net").resolve("fabricmc").resolve("fabric-loader").resolve(this.fabricVersion).resolve("fabric-loader-" + this.fabricVersion + ".jar"), new LinkOption[0]);
    }

    @Override
    public FabricLauncherEnvironment prepareModLoaderLauncher(@NotNull Path dirToInstall, InputStream stream) throws IOException {
        this.logger.info("Downloading fabric installer...");
        Path tempDirPath = dirToInstall.resolve(".flowupdater");
        FileUtils.deleteDirectory(tempDirPath);
        Path fabricPath = tempDirPath.resolve("tempfabric");
        Path installPath = tempDirPath.resolve(String.format("fabric-installer-%s.jar", this.installerVersion));
        Files.createDirectories(tempDirPath, new FileAttribute[0]);
        Files.createDirectories(fabricPath, new FileAttribute[0]);
        Files.copy(stream, installPath, StandardCopyOption.REPLACE_EXISTING);
        return this.makeCommand(tempDirPath, installPath, fabricPath);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    private FabricLauncherEnvironment makeCommand(Path tempDir, @NotNull Path install, @NotNull Path fabric) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("java");
        command.add("-Xmx256M");
        command.add("-jar");
        command.add(install.toString());
        command.add("client");
        command.add("-dir");
        command.add(fabric.toString());
        command.add("-mcversion");
        command.add(this.vanilla.getName());
        command.add("-loader");
        command.add(this.fabricVersion);
        command.add("-noprofile");
        return new FabricLauncherEnvironment(command, tempDir, fabric);
    }

    @Override
    public void install(Path dirToInstall) throws Exception {
        this.callback.step(Step.FABRIC);
        this.logger.info("Installing fabric, version: " + this.fabricVersion + "...");
        this.checkModLoaderEnv(dirToInstall);
        try (BufferedInputStream stream = new BufferedInputStream(this.installerUrl.openStream());){
            FabricLauncherEnvironment fabricLauncherEnvironment = this.prepareModLoaderLauncher(dirToInstall, stream);
            this.logger.info("Launching fabric installer...");
            fabricLauncherEnvironment.launchFabricInstaller();
            Path jsonPath = fabricLauncherEnvironment.getFabric().resolve("versions").resolve(String.format("fabric-loader-%s-%s", this.fabricVersion, this.vanilla.getName()));
            Path jsonFilePath = jsonPath.resolve(jsonPath.getFileName().toString() + ".json");
            JsonObject obj = JsonParser.parseString(StringUtils.toString(Files.readAllLines(jsonFilePath, StandardCharsets.UTF_8))).getAsJsonObject();
            JsonArray libs = obj.getAsJsonArray("libraries");
            Path libraries = dirToInstall.resolve("libraries");
            libs.forEach(el -> {
                JsonObject artifact = el.getAsJsonObject();
                String[] parts = artifact.get("name").getAsString().split(":");
                this.downloadArtifacts(libraries, artifact.get("url").getAsString(), parts);
            });
            this.logger.info("Successfully installed Fabric !");
            FileUtils.deleteDirectory(fabricLauncherEnvironment.getTempDir());
        }
        catch (Exception e) {
            this.logger.printStackTrace(e);
        }
    }

    private void downloadArtifacts(Path dir, String repositoryUrl, String[] metadata) {
        String group = metadata[0];
        String name = metadata[1];
        String version = metadata[2];
        String groupSlash = group.replace('.', '/');
        String groupDir = group.replace(".", dir.getFileSystem().getSeparator());
        try {
            IOUtils.download(this.logger, new URL(repositoryUrl + groupSlash + '/' + name + '/' + version + '/' + String.format("%s-%s.jar", name, version)), dir.resolve(groupDir).resolve(name).resolve(version).resolve(String.format("%s-%s.jar", name, version)));
        }
        catch (Exception e) {
            this.logger.printStackTrace(e);
        }
    }

    @Override
    public boolean checkModLoaderEnv(@NotNull Path dirToInstall) throws Exception {
        boolean result = false;
        Path fabricDirPath = dirToInstall.resolve("libraries").resolve("net").resolve("fabricmc").resolve("fabric-loader");
        if (Files.exists(fabricDirPath, new LinkOption[0])) {
            for (Path contained : FileUtils.list(fabricDirPath)) {
                if (contained.getFileName().toString().contains(this.fabricVersion)) continue;
                FileUtils.deleteDirectory(contained);
                result = true;
            }
        }
        return result;
    }

    @Override
    public void installMods(Path modsDir) throws Exception {
        this.callback.step(Step.MODS);
        this.installAllMods(modsDir);
        this.fileDeleter.delete(modsDir, this.mods, this.allCurseMods, null);
    }

    public ModFileDeleter getFileDeleter() {
        return this.fileDeleter;
    }

    @Override
    public void attachFlowUpdater(@NotNull FlowUpdater flowUpdater) {
        this.callback = flowUpdater.getCallback();
        this.logger = flowUpdater.getLogger();
        this.downloadList = flowUpdater.getDownloadList();
        this.vanilla = flowUpdater.getVanillaVersion();
        try {
            this.installerUrl = new URL(String.format("https://maven.fabricmc.net/net/fabricmc/fabric-installer/%s/fabric-installer-%s.jar", this.installerVersion, this.installerVersion));
        }
        catch (Exception e) {
            this.logger.printStackTrace(e);
        }
    }

    @Override
    public DownloadList getDownloadList() {
        return this.downloadList;
    }

    @Override
    public IProgressCallback getCallback() {
        return this.callback;
    }

    @Override
    public List<Mod> getMods() {
        return this.mods;
    }

    @Override
    public ILogger getLogger() {
        return this.logger;
    }

    public String getFabricVersion() {
        return this.fabricVersion;
    }

    public URL getInstallerUrl() {
        return this.installerUrl;
    }

    @Override
    public void setAllCurseMods(List<CurseMod> allCurseMods) {
        this.allCurseMods = allCurseMods;
    }

    @Override
    public List<CurseFileInfo> getCurseMods() {
        return this.curseMods;
    }

    @Override
    public CurseModPackInfo getModPackInfo() {
        return this.modPackInfo;
    }

    public static class FabricVersionBuilder
    implements IBuilder<FabricVersion> {
        private final BuilderArgument<String> fabricVersionArgument = new BuilderArgument<String>("FabricVersion", () -> FabricVersion.access$200()).optional();
        private final BuilderArgument<List<Mod>> modsArgument = new BuilderArgument<List>("Mods", ArrayList::new).optional();
        private final BuilderArgument<List<CurseFileInfo>> curseModsArgument = new BuilderArgument<List>("CurseMods", ArrayList::new).optional();
        private final BuilderArgument<ModFileDeleter> fileDeleterArgument = new BuilderArgument<ModFileDeleter>("ModFileDeleter", () -> new ModFileDeleter(false, new String[0])).optional();
        private final BuilderArgument<CurseModPackInfo> modPackArgument = new BuilderArgument("ModPack").optional();

        public FabricVersionBuilder withFabricVersion(String fabricVersion) {
            this.fabricVersionArgument.set(fabricVersion);
            return this;
        }

        public FabricVersionBuilder withMods(List<Mod> mods) {
            this.modsArgument.set(mods);
            return this;
        }

        public FabricVersionBuilder withCurseMods(List<CurseFileInfo> curseMods) {
            this.curseModsArgument.set(curseMods);
            return this;
        }

        public FabricVersionBuilder withCurseModPack(CurseModPackInfo modPackInfo) {
            this.modPackArgument.set(modPackInfo);
            return this;
        }

        public FabricVersionBuilder withFileDeleter(ModFileDeleter fileDeleter) {
            this.fileDeleterArgument.set(fileDeleter);
            return this;
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
        public FabricVersionBuilder withModPack(CurseModPackInfo modPackInfo) {
            this.modPackArgument.set(modPackInfo);
            return this;
        }

        @Override
        public FabricVersion build() throws BuilderException {
            return new FabricVersion(this.modsArgument.get(), this.curseModsArgument.get(), this.fabricVersionArgument.get(), this.fileDeleterArgument.get(), this.modPackArgument.get());
        }
    }

    private class FabricLauncherEnvironment
    extends IModLoaderVersion.ModLoaderLauncherEnvironment {
        private final Path fabric;

        public FabricLauncherEnvironment(List<String> command, Path tempDir, Path fabric) {
            super(command, tempDir);
            this.fabric = fabric;
        }

        public Path getFabric() {
            return this.fabric;
        }

        public void launchFabricInstaller() throws Exception {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder(this.getCommand());
            processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                FabricVersion.this.logger.info(line);
            }
            reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = reader.readLine()) != null) {
                FabricVersion.this.logger.info(line);
            }
            process.waitFor();
            reader.close();
        }
    }
}

