/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.utils;

import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowupdater.download.json.Mod;
import fr.flowarg.flowupdater.integrations.curseforgeintegration.CurseMod;
import fr.flowarg.flowupdater.integrations.optifineintegration.OptiFine;
import fr.flowarg.flowupdater.utils.IFileDeleter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ModFileDeleter
implements IFileDeleter {
    private final boolean useFileDeleter;
    private final String[] modsToIgnore;

    public ModFileDeleter(boolean useFileDeleter, String ... modsToIgnore) {
        this.useFileDeleter = useFileDeleter;
        this.modsToIgnore = modsToIgnore;
    }

    public void delete(Path modsDir, List<Mod> mods, List<CurseMod> allCurseMods, OptiFine optiFine) throws Exception {
        if (!this.isUseFileDeleter()) {
            return;
        }
        HashSet<Path> badFiles = new HashSet<Path>();
        ArrayList<Path> verifiedFiles = new ArrayList<Path>();
        Arrays.stream(this.modsToIgnore).forEach(fileName -> verifiedFiles.add(modsDir.resolve((String)fileName)));
        for (Path fileInDir : FileUtils.list(modsDir).stream().filter(path -> !Files.isDirectory(path, new LinkOption[0])).collect(Collectors.toList())) {
            if (verifiedFiles.contains(fileInDir)) continue;
            if (mods.isEmpty() && allCurseMods.isEmpty() && optiFine == null) {
                if (verifiedFiles.contains(fileInDir)) continue;
                badFiles.add(fileInDir);
                continue;
            }
            this.processCurseForgeMods(allCurseMods, fileInDir, badFiles, verifiedFiles);
            if (optiFine != null) {
                if (optiFine.getName().equalsIgnoreCase(fileInDir.getFileName().toString())) {
                    if (FileUtils.getFileSizeBytes(fileInDir) == (long)optiFine.getSize()) {
                        badFiles.remove(fileInDir);
                        verifiedFiles.add(fileInDir);
                    } else {
                        badFiles.add(fileInDir);
                    }
                } else if (!verifiedFiles.contains(fileInDir)) {
                    badFiles.add(fileInDir);
                }
            }
            for (Mod mod : mods) {
                if (mod.getName().equalsIgnoreCase(fileInDir.getFileName().toString())) {
                    if (FileUtils.getSHA1(fileInDir).equalsIgnoreCase(mod.getSha1()) && FileUtils.getFileSizeBytes(fileInDir) == mod.getSize()) {
                        badFiles.remove(fileInDir);
                        verifiedFiles.add(fileInDir);
                        continue;
                    }
                    badFiles.add(fileInDir);
                    continue;
                }
                if (verifiedFiles.contains(fileInDir)) continue;
                badFiles.add(fileInDir);
            }
        }
        badFiles.forEach(path -> {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        badFiles.clear();
    }

    private void processCurseForgeMods(@NotNull List<CurseMod> allCurseMods, Path fileInDir, Set<Path> badFiles, List<Path> verifiedFiles) throws Exception {
        for (CurseMod mod : allCurseMods) {
            if (mod.getName().equalsIgnoreCase(fileInDir.getFileName().toString())) {
                if (FileUtils.getFileSizeBytes(fileInDir) == (long)mod.getLength() && (mod.getMd5().contains("-") || FileUtils.getMD5(fileInDir).equalsIgnoreCase(mod.getMd5()))) {
                    badFiles.remove(fileInDir);
                    verifiedFiles.add(fileInDir);
                    continue;
                }
                badFiles.add(fileInDir);
                continue;
            }
            if (verifiedFiles.contains(fileInDir)) continue;
            badFiles.add(fileInDir);
        }
    }

    public boolean isUseFileDeleter() {
        return this.useFileDeleter;
    }

    public String[] getModsToIgnore() {
        return this.modsToIgnore;
    }
}

