/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.integrations.optifineintegration;

import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowlogger.ILogger;
import fr.flowarg.flowupdater.integrations.Integration;
import fr.flowarg.flowupdater.integrations.optifineintegration.OptiFine;
import fr.flowarg.flowupdater.utils.FlowUpdaterException;
import fr.flowarg.flowupdater.utils.IOUtils;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Optional;
import javax.net.ssl.HttpsURLConnection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OptiFineIntegration
extends Integration {
    public OptiFineIntegration(ILogger logger, Path folder) throws Exception {
        super(logger, folder);
    }

    public OptiFine getOptiFine(String optiFineVersion, boolean preview) {
        try {
            String name = preview ? (optiFineVersion.contains("preview_") && optiFineVersion.contains("OptiFine_") ? optiFineVersion + ".jar" : "preview_OptiFine_" + optiFineVersion + ".jar") : "OptiFine_" + optiFineVersion + ".jar";
            String newUrl = this.getNewURL(name, preview, optiFineVersion);
            GetResponse getResponse = this.getResponse(new URL(newUrl));
            int length = getResponse.contentLength;
            this.checkForUpdates(name, getResponse.byteStream, length, newUrl);
            getResponse.byteStream.close();
            if (length <= 40) {
                throw new FlowUpdaterException("Given version of OptiFine not found.");
            }
            return new OptiFine(name, length);
        }
        catch (Exception e) {
            throw new FlowUpdaterException(e);
        }
    }

    @NotNull
    private String getNewURL(String name, boolean preview, String optiFineVersion) {
        return "https://optifine.net/downloadx?f=" + name + "&x=" + (preview ? this.getJsonPreview(optiFineVersion) : this.getJson(optiFineVersion));
    }

    private void checkForUpdates(String name, InputStream byteStream, int length, String newUrl) throws Exception {
        Path outputPath = this.folder.resolve(name);
        if (Files.notExists(outputPath, new LinkOption[0]) || FileUtils.getFileSizeBytes(outputPath) != (long)length) {
            this.logger.info(String.format("Downloading %s from %s...", outputPath.getFileName().toString(), newUrl));
            Files.copy(byteStream, outputPath, StandardCopyOption.REPLACE_EXISTING);
        }
        byteStream.close();
    }

    @NotNull
    private String getJson(String optiFineVersion) {
        try {
            Object[] respLine = IOUtils.getContent(new URL("https://optifine.net/adloadx?f=OptiFine_" + optiFineVersion)).split("\n");
            Optional<String> result = Arrays.stream(respLine).filter(s2 -> s2.contains("downloadx?f=OptiFine")).findFirst();
            if (result.isPresent()) {
                return result.get().replace("' onclick='onDownload()'>OptiFine " + optiFineVersion.replace("_", " ") + "</a>", "").replace("<a href='downloadx?f=OptiFine_" + optiFineVersion + "&x=", "").replace(" ", "");
            }
            throw new FlowUpdaterException("No line found in: " + Arrays.toString(respLine));
        }
        catch (Exception e) {
            throw new FlowUpdaterException(e);
        }
    }

    @NotNull
    private String getJsonPreview(String optiFineVersion) {
        try {
            Object[] respLine = IOUtils.getContent(new URL("https://optifine.net/adloadx?f=" + optiFineVersion)).split("\n");
            Optional<String> result = Arrays.stream(respLine).filter(s2 -> s2.contains("downloadx?f=preview")).findFirst();
            if (result.isPresent()) {
                return result.get().replace("' onclick='onDownload()'>" + optiFineVersion.replace("_", " ") + "</a>", "").replace("<a href='downloadx?f=" + optiFineVersion + "&x=", "").replace(" ", "");
            }
            throw new FlowUpdaterException("No line found in: " + Arrays.toString(respLine));
        }
        catch (Exception e) {
            throw new FlowUpdaterException(e);
        }
    }

    @Contract(value="_ -> new")
    @NotNull
    private GetResponse getResponse(URL url) {
        try {
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            connection.addRequestProperty("User-Agent", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko) Chrome/43.0.2357.124 Safari/537.36");
            connection.setInstanceFollowRedirects(true);
            return new GetResponse(Integer.parseInt(connection.getHeaderField("Content-Length")), connection.getInputStream());
        }
        catch (Exception e) {
            throw new FlowUpdaterException(e);
        }
    }

    private static class GetResponse {
        public final int contentLength;
        public final InputStream byteStream;

        public GetResponse(int contentLength, InputStream byteStream) {
            this.contentLength = contentLength;
            this.byteStream = byteStream;
        }
    }
}

