/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.integrations.curseforgeintegration;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowlogger.ILogger;
import fr.flowarg.flowstringer.StringUtils;
import fr.flowarg.flowupdater.download.json.CurseFileInfo;
import fr.flowarg.flowupdater.download.json.CurseModPackInfo;
import fr.flowarg.flowupdater.integrations.Integration;
import fr.flowarg.flowupdater.integrations.curseforgeintegration.CurseMod;
import fr.flowarg.flowupdater.integrations.curseforgeintegration.CurseModPack;
import fr.flowarg.flowupdater.utils.FlowUpdaterException;
import fr.flowarg.flowupdater.utils.IOUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.net.ssl.HttpsURLConnection;
import org.jetbrains.annotations.NotNull;

public class CurseForgeIntegration
extends Integration {
    public CurseForgeIntegration(ILogger logger, Path folder) throws Exception {
        super(logger, folder);
    }

    @NotNull
    public CurseMod getCurseMod(int projectID, int fileID) throws Exception {
        String url = this.getURLOfFile(projectID, fileID);
        HttpURLConnection connection = null;
        try {
            String downloadURL = url.replace(" ", "%20");
            connection = (HttpsURLConnection)new URL(downloadURL).openConnection();
            connection.setRequestMethod("GET");
            connection.setInstanceFollowRedirects(true);
            connection.setUseCaches(false);
            String md5 = connection.getHeaderField("ETag").replace("\"", "");
            int length = Integer.parseInt(connection.getHeaderField("Content-Length"));
            CurseMod curseMod = new CurseMod(url.substring(url.lastIndexOf(47) + 1), downloadURL, md5, length);
            return curseMod;
        }
        catch (Exception e) {
            throw new FlowUpdaterException(e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public CurseModPack getCurseModPack(CurseModPackInfo info) {
        try {
            this.extractModPack(this.checkForUpdates(info.getUrl().isEmpty() ? this.getURLOfFile(info.getProjectID(), info.getFileID()) : info.getUrl()), info.isInstallExtFiles());
            return this.parseMods();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    private String getURLOfFile(int projectID, int fileID) throws Exception {
        return IOUtils.getContent(new URL(String.format("https://addons-ecs.forgesvc.net/api/v2/addon/%d/file/%d/download-url", projectID, fileID)));
    }

    @NotNull
    private CurseMod getCurseMod(@NotNull ProjectMod mod) throws Exception {
        return this.getCurseMod(mod.getProjectID(), mod.getFileID());
    }

    @NotNull
    private Path checkForUpdates(@NotNull String link) throws Exception {
        Path outPath = this.folder.resolve(link.substring(link.lastIndexOf(47) + 1));
        URL url = new URL(link);
        String md5 = this.getMD5(url);
        if (Files.notExists(outPath, new LinkOption[0]) || !md5.contains("-") && !md5.isEmpty() && !FileUtils.getMD5(outPath).equalsIgnoreCase(md5)) {
            IOUtils.download(this.logger, url, outPath);
        }
        return outPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private String getMD5(URL link) {
        HttpsURLConnection connection = null;
        try {
            connection = (HttpsURLConnection)link.openConnection();
            connection.setRequestMethod("GET");
            connection.setInstanceFollowRedirects(true);
            connection.setUseCaches(false);
            String string = connection.getHeaderField("ETag").replace("\"", "");
            return string;
        }
        catch (Exception e) {
            if (link.toExternalForm().contains("forgesvc")) {
                throw new FlowUpdaterException(e);
            }
            String string = "";
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void extractModPack(@NotNull Path out, boolean installExtFiles) throws Exception {
        this.logger.info("Extracting mod pack...");
        ZipFile zipFile = new ZipFile(out.toFile(), 1, StandardCharsets.UTF_8);
        Path dirPath = this.folder.getParent();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            Path flPath = dirPath.resolve(StringUtils.empty(entry.getName(), "overrides/"));
            String entryName = entry.getName();
            if (entryName.equalsIgnoreCase("manifest.json")) {
                if (!Files.notExists(flPath, new LinkOption[0]) && entry.getCrc() == FileUtils.getCRC32(flPath)) continue;
                this.transferAndClose(flPath, zipFile, entry);
                continue;
            }
            if (entryName.equals("modlist.html") || !installExtFiles || Files.exists(flPath, new LinkOption[0])) continue;
            if (flPath.getFileName().toString().endsWith(flPath.getFileSystem().getSeparator())) {
                Files.createDirectories(flPath, new FileAttribute[0]);
            }
            if (entry.isDirectory()) continue;
            this.transferAndClose(flPath, zipFile, entry);
        }
        zipFile.close();
    }

    private void transferAndClose(@NotNull Path flPath, ZipFile zipFile, ZipEntry entry) throws Exception {
        if (Files.notExists(flPath.getParent(), new LinkOption[0])) {
            Files.createDirectories(flPath.getParent(), new FileAttribute[0]);
        }
        try (OutputStream pathStream = Files.newOutputStream(flPath, new OpenOption[0]);
             BufferedOutputStream fo = new BufferedOutputStream(pathStream);
             InputStream is = zipFile.getInputStream(entry);){
            while (is.available() > 0) {
                fo.write(is.read());
            }
        }
    }

    @NotNull
    private CurseModPack parseMods() throws Exception {
        this.logger.info("Fetching mods...");
        Path dirPath = this.folder.getParent();
        BufferedReader manifestReader = Files.newBufferedReader(dirPath.resolve("manifest.json"));
        JsonObject manifestObj = JsonParser.parseReader(manifestReader).getAsJsonObject();
        ArrayList manifestFiles = new ArrayList();
        manifestObj.getAsJsonArray("files").forEach(jsonElement -> manifestFiles.add(ProjectMod.fromJsonObject(jsonElement.getAsJsonObject())));
        Path cachePath = dirPath.resolve("manifest.cache.json");
        if (Files.notExists(cachePath, new LinkOption[0])) {
            Files.write(cachePath, Collections.singletonList("[]"), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        BufferedReader cacheReader = Files.newBufferedReader(cachePath);
        JsonArray cacheArray = JsonParser.parseReader(cacheReader).getAsJsonArray();
        ConcurrentLinkedQueue mods = new ConcurrentLinkedQueue();
        cacheArray.forEach(jsonElement -> {
            JsonObject object = jsonElement.getAsJsonObject();
            String name = object.get("name").getAsString();
            String downloadURL = object.get("downloadURL").getAsString();
            String md5 = object.get("md5").getAsString();
            int length = object.get("length").getAsInt();
            ProjectMod projectMod = ProjectMod.fromJsonObject(object);
            mods.add(new CurseModPack.CurseModPackMod(name, downloadURL, md5, length, projectMod.isRequired()));
            manifestFiles.remove(projectMod);
        });
        ExecutorService executorService = Executors.newCachedThreadPool();
        ArrayList fails = new ArrayList();
        AtomicBoolean appendFails = new AtomicBoolean(false);
        manifestFiles.forEach(projectMod -> executorService.submit(() -> this.fetchAndSerializeProjectMod((ProjectMod)projectMod, cacheArray, appendFails, mods, fails)));
        try {
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        appendFails.set(true);
        if (!fails.isEmpty()) {
            Thread.sleep(1000L);
            fails.forEach(projectMod -> this.fetchAndSerializeProjectMod((ProjectMod)projectMod, cacheArray, appendFails, mods, fails));
        }
        manifestReader.close();
        cacheReader.close();
        Files.write(cachePath, Collections.singletonList(cacheArray.toString()), StandardCharsets.UTF_8, new OpenOption[0]);
        String modPackName = manifestObj.get("name").getAsString();
        String modPackVersion = manifestObj.get("version").getAsString();
        String modPackAuthor = manifestObj.get("author").getAsString();
        return new CurseModPack(modPackName, modPackVersion, modPackAuthor, new ArrayList<CurseModPack.CurseModPackMod>(mods));
    }

    private void fetchAndSerializeProjectMod(@NotNull ProjectMod projectMod, JsonArray cacheArray, AtomicBoolean appendFails, Queue<CurseModPack.CurseModPackMod> mods, List<ProjectMod> fails) {
        boolean required = projectMod.isRequired();
        try {
            CurseMod retrievedMod = this.getCurseMod(projectMod);
            CurseModPack.CurseModPackMod mod = new CurseModPack.CurseModPackMod(retrievedMod, required);
            JsonObject inCache = new JsonObject();
            inCache.addProperty("name", mod.getName());
            inCache.addProperty("downloadURL", mod.getDownloadURL());
            inCache.addProperty("md5", mod.getMd5());
            inCache.addProperty("length", mod.getLength());
            inCache.addProperty("required", required);
            inCache.addProperty("projectID", projectMod.getProjectID());
            inCache.addProperty("fileID", projectMod.getFileID());
            cacheArray.add(inCache);
            mods.add(mod);
        }
        catch (Exception e) {
            if (appendFails.get()) {
                fails.add(projectMod);
            }
            e.printStackTrace();
        }
    }

    private static class ProjectMod
    extends CurseFileInfo {
        private final boolean required;

        public ProjectMod(int projectID, int fileID, boolean required) {
            super(projectID, fileID);
            this.required = required;
        }

        @NotNull
        private static ProjectMod fromJsonObject(@NotNull JsonObject object) {
            return new ProjectMod(object.get("projectID").getAsInt(), object.get("fileID").getAsInt(), object.get("required").getAsBoolean());
        }

        public boolean isRequired() {
            return this.required;
        }
    }
}

