/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.integrations;

import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowlogger.ILogger;
import fr.flowarg.flowupdater.FlowUpdater;
import fr.flowarg.flowupdater.download.DownloadList;
import fr.flowarg.flowupdater.download.ICurseFeaturesUser;
import fr.flowarg.flowupdater.download.IProgressCallback;
import fr.flowarg.flowupdater.download.Step;
import fr.flowarg.flowupdater.download.json.CurseFileInfo;
import fr.flowarg.flowupdater.download.json.CurseModPackInfo;
import fr.flowarg.flowupdater.download.json.OptiFineInfo;
import fr.flowarg.flowupdater.integrations.curseforgeintegration.CurseForgeIntegration;
import fr.flowarg.flowupdater.integrations.curseforgeintegration.CurseMod;
import fr.flowarg.flowupdater.integrations.curseforgeintegration.CurseModPack;
import fr.flowarg.flowupdater.integrations.optifineintegration.OptiFine;
import fr.flowarg.flowupdater.integrations.optifineintegration.OptiFineIntegration;
import fr.flowarg.flowupdater.versions.AbstractForgeVersion;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class IntegrationManager {
    private final IProgressCallback progressCallback;
    private final ILogger logger;
    private final DownloadList downloadList;

    public IntegrationManager(@NotNull FlowUpdater updater) {
        this.progressCallback = updater.getCallback();
        this.logger = updater.getLogger();
        this.downloadList = updater.getDownloadList();
    }

    public void loadCurseForgeIntegration(Path dir, ICurseFeaturesUser curseFeaturesUser) {
        this.progressCallback.step(Step.INTEGRATION);
        try {
            CurseModPackInfo modPackInfo = curseFeaturesUser.getModPackInfo();
            ArrayList<CurseMod> allCurseMods = new ArrayList<CurseMod>();
            if (curseFeaturesUser.getCurseMods().isEmpty() && modPackInfo == null) {
                curseFeaturesUser.setAllCurseMods(allCurseMods);
                return;
            }
            CurseForgeIntegration curseForgeIntegration = new CurseForgeIntegration(this.logger, dir.getParent().resolve(".cfp"));
            for (CurseFileInfo info : curseFeaturesUser.getCurseMods()) {
                CurseMod mod2 = curseForgeIntegration.getCurseMod(info.getProjectID(), info.getFileID());
                allCurseMods.add(mod2);
                Path filePath = dir.resolve(mod2.getName());
                if (Files.exists(filePath, new LinkOption[0]) && FileUtils.getFileSizeBytes(filePath) == (long)mod2.getLength() && (FileUtils.getMD5(filePath).equalsIgnoreCase(mod2.getMd5()) || mod2.getMd5().contains("-"))) continue;
                Files.deleteIfExists(filePath);
                this.downloadList.getCurseMods().add(mod2);
            }
            if (modPackInfo == null) {
                curseFeaturesUser.setAllCurseMods(allCurseMods);
                return;
            }
            this.progressCallback.step(Step.MOD_PACK);
            CurseModPack modPack = curseForgeIntegration.getCurseModPack(modPackInfo);
            this.logger.info(String.format("Loading mod pack: %s (%s) by %s.", modPack.getName(), modPack.getVersion(), modPack.getAuthor()));
            modPack.getMods().forEach(mod -> {
                allCurseMods.add((CurseMod)mod);
                try {
                    Path filePath = dir.resolve(mod.getName());
                    boolean flag = false;
                    for (String exclude : modPackInfo.getExcluded()) {
                        if (!mod.getName().equalsIgnoreCase(exclude)) continue;
                        flag = !mod.isRequired();
                        break;
                    }
                    if (flag) {
                        return;
                    }
                    if (Files.exists(filePath, new LinkOption[0]) && FileUtils.getFileSizeBytes(filePath) == (long)mod.getLength() && (FileUtils.getMD5(filePath).equalsIgnoreCase(mod.getMd5()) || mod.getMd5().contains("-"))) {
                        return;
                    }
                    Files.deleteIfExists(filePath);
                    this.downloadList.getCurseMods().add((CurseMod)mod);
                }
                catch (Exception e) {
                    this.logger.printStackTrace(e);
                }
            });
            curseFeaturesUser.setAllCurseMods(allCurseMods);
        }
        catch (Exception e) {
            this.logger.printStackTrace(e);
        }
    }

    public void loadOptiFineIntegration(Path dir, @NotNull AbstractForgeVersion forgeVersion) {
        OptiFineInfo info = forgeVersion.getOptiFineInfo();
        if (info == null) {
            return;
        }
        try {
            OptiFineIntegration optifineIntegration = new OptiFineIntegration(this.logger, dir.getParent().resolve(".op"));
            OptiFine optifine = optifineIntegration.getOptiFine(info.getVersion(), info.isPreview());
            this.downloadList.setOptiFine(optifine);
        }
        catch (Exception e) {
            this.logger.printStackTrace(e);
        }
    }
}

