/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.download.json;

import com.google.gson.JsonObject;
import fr.flowarg.flowupdater.utils.FlowUpdaterException;
import fr.flowarg.flowupdater.utils.IOUtils;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class MCP {
    private final String clientURL;
    private final String clientSha1;
    private final long clientSize;
    private String serverURL;
    private String serverSha1;
    private long serverSize;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public MCP(String clientURL, String clientSha1, long clientSize, String serverURL, String serverSha1, long serverSize) {
        this.clientURL = clientURL;
        this.clientSha1 = clientSha1;
        this.clientSize = clientSize;
        this.serverURL = serverURL;
        this.serverSha1 = serverSha1;
        this.serverSize = serverSize;
    }

    public MCP(String clientURL, String clientSha1, long clientSize) {
        this.clientURL = clientURL;
        this.clientSha1 = clientSha1;
        this.clientSize = clientSize;
    }

    @NotNull
    public static MCP getMCPFromJson(URL jsonUrl) {
        JsonObject object = IOUtils.readJson(jsonUrl).getAsJsonObject();
        return new MCP(object.get("clientURL").getAsString(), object.get("clientSha1").getAsString(), object.get("clientSize").getAsLong());
    }

    @NotNull
    public static MCP getMCPFromJson(String jsonUrl) {
        try {
            return MCP.getMCPFromJson(new URL(jsonUrl));
        }
        catch (MalformedURLException e) {
            throw new FlowUpdaterException(e);
        }
    }

    public String getClientURL() {
        return this.clientURL;
    }

    public String getClientSha1() {
        return this.clientSha1;
    }

    public long getClientSize() {
        return this.clientSize;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public String getServerSha1() {
        return this.serverSha1;
    }

    public long getServerSize() {
        return this.serverSize;
    }
}

