/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.download.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import fr.flowarg.flowupdater.utils.FlowUpdaterException;
import fr.flowarg.flowupdater.utils.IOUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CurseFileInfo {
    private final int projectID;
    private final int fileID;

    public CurseFileInfo(int projectID, int fileID) {
        this.projectID = projectID;
        this.fileID = fileID;
    }

    @NotNull
    public static List<CurseFileInfo> getFilesFromJson(URL jsonUrl) {
        ArrayList<CurseFileInfo> result = new ArrayList<CurseFileInfo>();
        JsonObject object = IOUtils.readJson(jsonUrl).getAsJsonObject();
        JsonArray mods = object.getAsJsonArray("curseFiles");
        mods.forEach(curseModElement -> {
            JsonObject obj = curseModElement.getAsJsonObject();
            int projectID = obj.get("projectID").getAsInt();
            int fileID = obj.get("fileID").getAsInt();
            result.add(new CurseFileInfo(projectID, fileID));
        });
        return result;
    }

    @NotNull
    public static List<CurseFileInfo> getFilesFromJson(String jsonUrl) {
        try {
            return CurseFileInfo.getFilesFromJson(new URL(jsonUrl));
        }
        catch (Exception e) {
            throw new FlowUpdaterException(e);
        }
    }

    public int getProjectID() {
        return this.projectID;
    }

    public int getFileID() {
        return this.fileID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurseFileInfo that = (CurseFileInfo)o;
        return this.projectID == that.projectID && this.fileID == that.fileID;
    }

    public int hashCode() {
        return Objects.hash(this.projectID, this.fileID);
    }
}

