/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater.download;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fr.flowarg.flowcompat.Platform;
import fr.flowarg.flowlogger.ILogger;
import fr.flowarg.flowupdater.FlowUpdater;
import fr.flowarg.flowupdater.download.DownloadList;
import fr.flowarg.flowupdater.download.IProgressCallback;
import fr.flowarg.flowupdater.download.Step;
import fr.flowarg.flowupdater.download.json.AssetDownloadable;
import fr.flowarg.flowupdater.download.json.AssetIndex;
import fr.flowarg.flowupdater.download.json.Downloadable;
import fr.flowarg.flowupdater.utils.IOUtils;
import fr.flowarg.flowupdater.versions.VanillaVersion;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class VanillaReader {
    private final VanillaVersion version;
    private final ILogger logger;
    private final boolean shouldLog;
    private final IProgressCallback callback;
    private final DownloadList downloadList;
    private final boolean downloadServer;

    public VanillaReader(@NotNull FlowUpdater flowUpdater) {
        this.version = flowUpdater.getVanillaVersion();
        this.logger = flowUpdater.getLogger();
        this.shouldLog = !flowUpdater.getUpdaterOptions().isSilentRead();
        this.callback = flowUpdater.getCallback();
        this.downloadList = flowUpdater.getDownloadList();
        this.downloadServer = flowUpdater.getUpdaterOptions().isDownloadServer();
    }

    private void silentDebug(String message) {
        if (this.shouldLog) {
            this.logger.debug(message);
        }
    }

    public void read() throws IOException {
        this.callback.step(Step.READ);
        this.silentDebug("Parsing libraries information...");
        long start = System.currentTimeMillis();
        this.parseLibraries();
        this.silentDebug("Parsing asset index information...");
        this.parseAssetIndex();
        this.silentDebug("Parsing the information of client/server's jar...");
        this.parseClientServer();
        this.silentDebug("Parsing natives information...");
        this.parseNatives();
        this.silentDebug("Parsing assets information...");
        this.parseAssets();
        this.silentDebug("Parsing of the json file took " + (System.currentTimeMillis() - start) + " milliseconds...");
    }

    private void parseLibraries() {
        this.version.getMinecraftLibrariesJson().forEach(jsonElement -> {
            JsonObject element = jsonElement.getAsJsonObject();
            if (element == null) {
                return;
            }
            if (!this.checkRules(element)) {
                return;
            }
            JsonObject artifact = element.getAsJsonObject("downloads").getAsJsonObject("artifact");
            if (artifact == null) {
                return;
            }
            String url = artifact.getAsJsonPrimitive("url").getAsString();
            int size = artifact.getAsJsonPrimitive("size").getAsInt();
            String path = "libraries/" + artifact.getAsJsonPrimitive("path").getAsString();
            String sha1 = artifact.getAsJsonPrimitive("sha1").getAsString();
            this.silentDebug("Reading " + path + " from " + url + "... SHA1 is : " + sha1);
            Downloadable downloadable = new Downloadable(url, size, sha1, path);
            if (!this.downloadList.getDownloadableFiles().contains(downloadable)) {
                this.downloadList.getDownloadableFiles().add(downloadable);
            }
        });
        this.downloadList.getDownloadableFiles().addAll(this.version.getAnotherLibraries());
    }

    private void parseAssetIndex() {
        if (this.version.getCustomAssetIndex() != null) {
            return;
        }
        JsonObject assetIndex = this.version.getMinecraftAssetIndex();
        String url = assetIndex.getAsJsonPrimitive("url").getAsString();
        int size = assetIndex.getAsJsonPrimitive("size").getAsInt();
        String name = "assets/indexes/" + url.substring(url.lastIndexOf(47) + 1);
        String sha1 = assetIndex.getAsJsonPrimitive("sha1").getAsString();
        this.silentDebug("Reading assets index from " + url + "... SHA1 is : " + sha1);
        this.downloadList.getDownloadableFiles().add(new Downloadable(url, size, sha1, name));
    }

    private void parseClientServer() {
        JsonObject client = this.version.getMinecraftClient();
        String clientURL = client.getAsJsonPrimitive("url").getAsString();
        int clientSize = client.getAsJsonPrimitive("size").getAsInt();
        String clientName = clientURL.substring(clientURL.lastIndexOf(47) + 1);
        String clientSha1 = client.getAsJsonPrimitive("sha1").getAsString();
        this.silentDebug("Reading client jar from " + clientURL + "... SHA1 is : " + clientSha1);
        this.downloadList.getDownloadableFiles().add(new Downloadable(clientURL, clientSize, clientSha1, clientName));
        if (!this.downloadServer) {
            return;
        }
        JsonObject server = this.version.getMinecraftServer();
        String serverURL = server.getAsJsonPrimitive("url").getAsString();
        int serverSize = server.getAsJsonPrimitive("size").getAsInt();
        String serverName = serverURL.substring(serverURL.lastIndexOf(47) + 1);
        String serverSha1 = server.getAsJsonPrimitive("sha1").getAsString();
        this.silentDebug("Reading server jar from " + serverURL + "... SHA1 is : " + serverSha1);
        this.downloadList.getDownloadableFiles().add(new Downloadable(serverURL, serverSize, serverSha1, serverName));
    }

    private void parseNatives() {
        this.version.getMinecraftLibrariesJson().forEach(jsonElement -> {
            JsonObject obj = jsonElement.getAsJsonObject().getAsJsonObject("downloads").getAsJsonObject("classifiers");
            if (obj == null) {
                return;
            }
            JsonObject macObj = obj.getAsJsonObject("natives-macos");
            JsonObject osxObj = obj.getAsJsonObject("natives-osx");
            JsonObject windowsObj = obj.getAsJsonObject(String.format("natives-windows-%s", Platform.getArch()));
            if (windowsObj == null) {
                windowsObj = obj.getAsJsonObject("natives-windows");
            }
            JsonObject linuxObj = obj.getAsJsonObject("natives-linux");
            if (macObj != null && Platform.isOnMac()) {
                this.getNativeForOS("mac", macObj);
            } else if (osxObj != null && Platform.isOnMac()) {
                this.getNativeForOS("mac", osxObj);
            } else if (windowsObj != null && Platform.isOnWindows()) {
                this.getNativeForOS("win", windowsObj);
            } else if (linuxObj != null && Platform.isOnLinux()) {
                this.getNativeForOS("linux", linuxObj);
            }
        });
    }

    private void getNativeForOS(@NotNull String os, @NotNull JsonObject obj) {
        String url = obj.getAsJsonPrimitive("url").getAsString();
        int size = obj.getAsJsonPrimitive("size").getAsInt();
        String path = obj.getAsJsonPrimitive("path").getAsString();
        String name = "natives/" + path.substring(path.lastIndexOf(47) + 1);
        String sha1 = obj.getAsJsonPrimitive("sha1").getAsString();
        if (!os.equals("mac")) {
            if (name.contains("-3.2.1-") && name.contains("lwjgl")) {
                return;
            }
            if (name.contains("-2.9.2-") && name.contains("lwjgl")) {
                return;
            }
        } else if (name.contains("-3.2.2-") && name.contains("lwjgl")) {
            return;
        }
        this.silentDebug("Reading " + name + " from " + url + "... SHA1 is : " + sha1);
        this.downloadList.getDownloadableFiles().add(new Downloadable(url, size, sha1, name));
    }

    private void parseAssets() throws IOException {
        HashSet<AssetDownloadable> toDownload = new HashSet<AssetDownloadable>(this.version.getAnotherAssets());
        AssetIndex assetIndex = this.version.getCustomAssetIndex() == null ? new GsonBuilder().disableHtmlEscaping().create().fromJson(IOUtils.getContent(new URL(this.version.getMinecraftAssetIndex().get("url").getAsString())), AssetIndex.class) : this.version.getCustomAssetIndex();
        assetIndex.getUniqueObjects().values().forEach(assetDownloadable -> toDownload.add(new AssetDownloadable(assetDownloadable.getHash(), assetDownloadable.getSize())));
        this.downloadList.getDownloadableAssets().addAll(toDownload);
    }

    private boolean checkRules(@NotNull JsonObject obj) {
        JsonElement rulesElement = obj.get("rules");
        if (rulesElement == null) {
            return true;
        }
        AtomicBoolean canDownload = new AtomicBoolean(true);
        rulesElement.getAsJsonArray().forEach(jsonElement -> {
            JsonObject object = jsonElement.getAsJsonObject();
            String actionValue = object.getAsJsonPrimitive("action").getAsString();
            JsonObject osObject = object.getAsJsonObject("os");
            if (actionValue.equals("allow")) {
                if (osObject == null) {
                    return;
                }
                String os = osObject.getAsJsonPrimitive("name").getAsString();
                canDownload.set(this.check(os));
            } else if (actionValue.equals("disallow")) {
                String os = osObject.getAsJsonPrimitive("name").getAsString();
                canDownload.set(!this.check(os));
            }
        });
        return canDownload.get();
    }

    private boolean check(@NotNull String os) {
        return os.equalsIgnoreCase("osx") && Platform.isOnMac() || os.equalsIgnoreCase("macos") && Platform.isOnMac() || os.equalsIgnoreCase("windows") && Platform.isOnWindows() || os.equalsIgnoreCase("linux") && Platform.isOnLinux();
    }
}

