/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowupdater;

import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowlogger.ILogger;
import fr.flowarg.flowlogger.Logger;
import fr.flowarg.flowupdater.download.DownloadList;
import fr.flowarg.flowupdater.download.IProgressCallback;
import fr.flowarg.flowupdater.download.Step;
import fr.flowarg.flowupdater.download.VanillaDownloader;
import fr.flowarg.flowupdater.download.VanillaReader;
import fr.flowarg.flowupdater.download.json.ExternalFile;
import fr.flowarg.flowupdater.download.json.Mod;
import fr.flowarg.flowupdater.integrations.IntegrationManager;
import fr.flowarg.flowupdater.utils.IOUtils;
import fr.flowarg.flowupdater.utils.UpdaterOptions;
import fr.flowarg.flowupdater.utils.builderapi.BuilderArgument;
import fr.flowarg.flowupdater.utils.builderapi.BuilderException;
import fr.flowarg.flowupdater.utils.builderapi.IBuilder;
import fr.flowarg.flowupdater.versions.AbstractForgeVersion;
import fr.flowarg.flowupdater.versions.FabricVersion;
import fr.flowarg.flowupdater.versions.IModLoaderVersion;
import fr.flowarg.flowupdater.versions.VanillaVersion;
import fr.flowarg.flowupdater.versions.VersionType;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class FlowUpdater {
    private final VanillaVersion vanillaVersion;
    private final ILogger logger;
    private final AbstractForgeVersion forgeVersion;
    private final FabricVersion fabricVersion;
    private final IProgressCallback callback;
    private final DownloadList downloadList;
    private final UpdaterOptions updaterOptions;
    private final List<ExternalFile> externalFiles;
    private final List<Runnable> postExecutions;
    private final IntegrationManager integrationManager;
    public static final IProgressCallback NULL_CALLBACK = new IProgressCallback(){

        @Override
        public void init(@NotNull ILogger logger) {
            logger.info("Default callback will be used.");
        }
    };
    public static final ILogger DEFAULT_LOGGER = new Logger("[FlowUpdater]", null);

    private FlowUpdater(VanillaVersion vanillaVersion, ILogger logger, UpdaterOptions updaterOptions, IProgressCallback callback, List<ExternalFile> externalFiles, List<Runnable> postExecutions, AbstractForgeVersion forgeVersion, FabricVersion fabricVersion) {
        this.logger = logger;
        this.vanillaVersion = vanillaVersion;
        this.externalFiles = externalFiles;
        this.postExecutions = postExecutions;
        this.forgeVersion = forgeVersion;
        this.fabricVersion = fabricVersion;
        this.updaterOptions = updaterOptions;
        this.callback = callback;
        this.downloadList = new DownloadList();
        this.integrationManager = new IntegrationManager(this);
        this.logger.info(String.format("------------------------- FlowUpdater for Minecraft %s v%s -------------------------", this.vanillaVersion.getName(), "1.5.3"));
        this.callback.init(this.logger);
    }

    public void update(Path dir) throws Exception {
        this.checkExtFiles(dir);
        this.updateMinecraft(dir);
        this.updateExtFiles(dir);
        this.runPostExecutions();
        this.endUpdate();
    }

    private void checkExtFiles(Path dir) throws Exception {
        this.updaterOptions.getExternalFileDeleter().delete(this.externalFiles, this.downloadList, dir);
    }

    private void updateMinecraft(Path dir) throws Exception {
        if (this.vanillaVersion == VanillaVersion.NULL_VERSION) {
            this.downloadList.init();
            return;
        }
        this.logger.info(String.format("Reading data about %s Minecraft version...", this.vanillaVersion.getName()));
        new VanillaReader(this).read();
        Path modsDirPath = dir.resolve("mods");
        VersionType versionType = this.vanillaVersion.getVersionType();
        if (this.forgeVersion != null && versionType == VersionType.FORGE) {
            this.checkMods(this.forgeVersion, modsDirPath);
            this.integrationManager.loadCurseForgeIntegration(modsDirPath, this.forgeVersion);
            this.integrationManager.loadOptiFineIntegration(modsDirPath, this.forgeVersion);
        }
        if (this.fabricVersion != null && versionType == VersionType.FABRIC) {
            this.checkMods(this.fabricVersion, modsDirPath);
            this.integrationManager.loadCurseForgeIntegration(modsDirPath, this.fabricVersion);
        }
        if (Files.notExists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        new VanillaDownloader(dir, this).download();
        if (versionType == VersionType.MCP || versionType == VersionType.VANILLA) {
            return;
        }
        if (versionType == VersionType.FORGE) {
            this.installModLoader(this.forgeVersion, dir, "Forge");
        }
        if (versionType == VersionType.FABRIC) {
            this.installModLoader(this.fabricVersion, dir, "Fabric");
        }
    }

    private void checkMods(@NotNull IModLoaderVersion modLoader, Path modsDir) throws Exception {
        for (Mod mod : modLoader.getMods()) {
            Path filePath = modsDir.resolve(mod.getName());
            if (!Files.notExists(filePath, new LinkOption[0]) && FileUtils.getSHA1(filePath).equalsIgnoreCase(mod.getSha1()) && FileUtils.getFileSizeBytes(filePath) == mod.getSize()) continue;
            this.downloadList.getMods().add(mod);
        }
    }

    private void installModLoader(IModLoaderVersion modLoader, Path dir, String name) throws Exception {
        if (modLoader == null) {
            return;
        }
        modLoader.attachFlowUpdater(this);
        if (!modLoader.isModLoaderAlreadyInstalled(dir)) {
            modLoader.install(dir);
        } else {
            this.logger.info(name + " is already installed! Skipping installation...");
        }
        modLoader.installMods(dir.resolve("mods"));
    }

    private void updateExtFiles(Path dir) {
        if (this.downloadList.getExtFiles().isEmpty()) {
            return;
        }
        this.callback.step(Step.EXTERNAL_FILES);
        this.logger.info("Downloading external file(s)...");
        this.downloadList.getExtFiles().forEach(extFile -> {
            try {
                Path filePath = dir.resolve(extFile.getPath());
                IOUtils.download(this.logger, new URL(extFile.getDownloadURL()), filePath);
                this.callback.onFileDownloaded(filePath);
            }
            catch (IOException e) {
                this.logger.printStackTrace(e);
            }
            this.downloadList.incrementDownloaded(extFile.getSize());
            this.callback.update(this.downloadList.getDownloadInfo());
        });
    }

    private void runPostExecutions() {
        if (this.postExecutions.isEmpty()) {
            return;
        }
        this.callback.step(Step.POST_EXECUTIONS);
        this.logger.info("Running post executions...");
        this.postExecutions.forEach(Runnable::run);
    }

    private void endUpdate() {
        this.callback.step(Step.END);
        this.callback.update(this.downloadList.getDownloadInfo());
        this.downloadList.clear();
    }

    public VanillaVersion getVanillaVersion() {
        return this.vanillaVersion;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public AbstractForgeVersion getForgeVersion() {
        return this.forgeVersion;
    }

    public IProgressCallback getCallback() {
        return this.callback;
    }

    public List<ExternalFile> getExternalFiles() {
        return this.externalFiles;
    }

    public List<Runnable> getPostExecutions() {
        return this.postExecutions;
    }

    public DownloadList getDownloadList() {
        return this.downloadList;
    }

    public UpdaterOptions getUpdaterOptions() {
        return this.updaterOptions;
    }

    public FabricVersion getFabricVersion() {
        return this.fabricVersion;
    }

    public static class FlowUpdaterBuilder
    implements IBuilder<FlowUpdater> {
        private final BuilderArgument<VanillaVersion> versionArgument = new BuilderArgument<VanillaVersion>("VanillaVersion", () -> VanillaVersion.NULL_VERSION).optional();
        private final BuilderArgument<ILogger> loggerArgument = new BuilderArgument<ILogger>("Logger", () -> DEFAULT_LOGGER).optional();
        private final BuilderArgument<UpdaterOptions> updaterOptionsArgument = new BuilderArgument<UpdaterOptions>("UpdaterOptions", () -> UpdaterOptions.DEFAULT).optional();
        private final BuilderArgument<IProgressCallback> progressCallbackArgument = new BuilderArgument<IProgressCallback>("Callback", () -> NULL_CALLBACK).optional();
        private final BuilderArgument<List<ExternalFile>> externalFilesArgument = new BuilderArgument<List>("External Files", ArrayList::new).optional();
        private final BuilderArgument<List<Runnable>> postExecutionsArgument = new BuilderArgument<List>("Post Executions", ArrayList::new).optional();
        private final BuilderArgument<AbstractForgeVersion> forgeVersionArgument = new BuilderArgument("ForgeVersion").optional().require(this.versionArgument);
        private final BuilderArgument<FabricVersion> fabricVersionArgument = new BuilderArgument("FabricVersion").optional().require(this.versionArgument);

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
        public FlowUpdaterBuilder withVersion(VanillaVersion version) {
            this.versionArgument.set(version);
            return this;
        }

        public FlowUpdaterBuilder withVanillaVersion(VanillaVersion version) {
            this.versionArgument.set(version);
            return this;
        }

        public FlowUpdaterBuilder withLogger(ILogger logger) {
            this.loggerArgument.set(logger);
            return this;
        }

        public FlowUpdaterBuilder withUpdaterOptions(UpdaterOptions updaterOptions) {
            this.updaterOptionsArgument.set(updaterOptions);
            return this;
        }

        public FlowUpdaterBuilder withProgressCallback(IProgressCallback callback) {
            this.progressCallbackArgument.set(callback);
            return this;
        }

        public FlowUpdaterBuilder withExternalFiles(List<ExternalFile> externalFiles) {
            this.externalFilesArgument.set(externalFiles);
            return this;
        }

        public FlowUpdaterBuilder withPostExecutions(List<Runnable> postExecutions) {
            this.postExecutionsArgument.set(postExecutions);
            return this;
        }

        public FlowUpdaterBuilder withForgeVersion(AbstractForgeVersion forgeVersion) {
            this.forgeVersionArgument.set(forgeVersion);
            return this;
        }

        public FlowUpdaterBuilder withFabricVersion(FabricVersion fabricVersion) {
            this.fabricVersionArgument.set(fabricVersion);
            return this;
        }

        @Override
        public FlowUpdater build() throws BuilderException {
            return new FlowUpdater(this.versionArgument.get(), this.loggerArgument.get(), this.updaterOptionsArgument.get(), this.progressCallbackArgument.get(), this.externalFilesArgument.get(), this.postExecutionsArgument.get(), this.forgeVersionArgument.get(), this.fabricVersionArgument.get());
        }
    }
}

