/*
 * Decompiled with CFR 0.152.
 */
package fr.antoineok.flowupdater.optifineplugin;

import fr.antoineok.flowupdater.optifineplugin.Optifine;
import fr.flowarg.flowio.FileUtils;
import fr.flowarg.flowlogger.ILogger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class OptifinePlugin {
    public static final OptifinePlugin INSTANCE = new OptifinePlugin();
    private final OkHttpClient client = new OkHttpClient();
    private ILogger logger;
    private Path folder;

    public Optifine getOptifine(String optifineVersion, boolean preview) throws IOException {
        String name = preview ? (optifineVersion.contains("preview_") && optifineVersion.contains("OptiFine_") ? optifineVersion + ".jar" : "preview_OptiFine_" + optifineVersion + ".jar") : "OptiFine_" + optifineVersion + ".jar";
        String newUrl = this.getNewURL(name, preview, optifineVersion);
        Request request = new Request.Builder().url(newUrl).build();
        Response response = this.client.newCall(request).execute();
        int length = Integer.parseInt(Objects.requireNonNull(response.header("Content-Length")));
        assert (response.body() != null);
        this.checkForUpdates(name, response.body().byteStream(), length, newUrl);
        response.body().close();
        if (length <= 40) {
            throw new IOException("Given version of Optifine not found.");
        }
        return new Optifine(name, length);
    }

    private String getNewURL(String name, boolean preview, String optifineVersion) {
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse("https://optifine.net/downloadx")).newBuilder();
        urlBuilder.addQueryParameter("f", name);
        urlBuilder.addQueryParameter("x", preview ? this.getJsonPreview(optifineVersion) : this.getJson(optifineVersion));
        return urlBuilder.build().toString();
    }

    private void checkForUpdates(String name, InputStream byteStream, int length, String newUrl) throws IOException {
        Path outputPath = Paths.get(this.getFolder().toString(), name);
        if (Files.notExists(outputPath, new LinkOption[0]) || FileUtils.getFileSizeBytes(outputPath) != (long)length) {
            this.getLogger().info(String.format("Downloading %s from %s...", outputPath.getFileName().toString(), newUrl));
            Files.copy(byteStream, outputPath, StandardCopyOption.REPLACE_EXISTING);
        }
        byteStream.close();
    }

    public void shutdownOKHTTP() {
        this.client.dispatcher().executorService().shutdown();
        this.client.connectionPool().evictAll();
        if (this.client.cache() != null) {
            try {
                Objects.requireNonNull(this.client.cache()).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getJson(String optifineVersion) {
        Request request = new Request.Builder().url("https://optifine.net/adloadx?f=OptiFine_" + optifineVersion).build();
        try {
            Response response = this.client.newCall(request).execute();
            assert (response.body() != null);
            String resp = response.body().string();
            String[] respLine = resp.split("\n");
            response.body().close();
            String keyLine = "";
            for (String line : respLine) {
                if (!line.contains("downloadx?f=OptiFine")) continue;
                keyLine = line;
                break;
            }
            return keyLine.replace("' onclick='onDownload()'>OptiFine " + optifineVersion.replace("_", " ") + "</a>", "").replace("<a href='downloadx?f=OptiFine_" + optifineVersion + "&x=", "").replace(" ", "");
        }
        catch (IOException e) {
            this.getLogger().printStackTrace(e);
            return "";
        }
    }

    private String getJsonPreview(String optifineVersion) {
        Request request = new Request.Builder().url("https://optifine.net/adloadx?f=" + optifineVersion).build();
        try {
            Response response = this.client.newCall(request).execute();
            assert (response.body() != null);
            String resp = response.body().string();
            String[] respLine = resp.split("\n");
            response.body().close();
            String keyLine = "";
            for (String line : respLine) {
                if (!line.contains("downloadx?f=preview")) continue;
                keyLine = line;
                break;
            }
            return keyLine.replace("' onclick='onDownload()'>" + optifineVersion.replace("_", " ") + "</a>", "").replace("<a href='downloadx?f=" + optifineVersion + "&x=", "").replace(" ", "");
        }
        catch (IOException e) {
            this.getLogger().printStackTrace(e);
            return "";
        }
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public Path getFolder() {
        return this.folder;
    }

    public void setFolder(Path folder) {
        this.folder = folder;
        try {
            Files.createDirectories(this.folder, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.logger.printStackTrace(e);
        }
    }
}

