/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.util;

import com.google.common.base.Preconditions;
import com.squareup.moshi.Moshi;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.util.ElementAdapter;
import com.therandomlabs.curseapi.util.HttpUrlAdapter;
import com.therandomlabs.curseapi.util.ZonedDateTimeAdapter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;

public final class MoshiUtils {
    public static final Moshi moshi = new Moshi.Builder().add(ElementAdapter.INSTANCE).add(HttpUrlAdapter.INSTANCE).add(ZonedDateTimeAdapter.INSTANCE).build();

    private MoshiUtils() {
    }

    public static <T> T fromJSON(String json, Class<T> type) throws CurseException {
        Preconditions.checkNotNull(json, "json should not be null");
        Preconditions.checkNotNull(type, "type should not be null");
        try {
            return moshi.adapter(type).fromJson(json);
        }
        catch (IOException ex) {
            throw new CurseException("Failed to read JSON: " + json, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T fromJSON(Path json, Class<T> type) throws CurseException {
        Preconditions.checkNotNull(json, "json should not be null");
        Preconditions.checkNotNull(type, "type should not be null");
        try (BufferedSource source2 = Okio.buffer(Okio.source(json, new OpenOption[0]));){
            T t = MoshiUtils.fromJSON(source2.readUtf8(), type);
            return t;
        }
        catch (IOException ex) {
            throw new CurseException("Failed to read JSON: " + json, ex);
        }
    }

    public static <T> String toJSON(T value) {
        Preconditions.checkNotNull(value, "value should not be null");
        return moshi.adapter((Type)value.getClass()).indent("  ").toJson(value);
    }

    public static <T> void toJSON(T value, Path path) throws CurseException {
        Preconditions.checkNotNull(value, "value should not be null");
        Preconditions.checkNotNull(path, "path should not be null");
        try (BufferedSink sink2 = Okio.buffer(Okio.sink(path, new OpenOption[0]));){
            sink2.writeUtf8(MoshiUtils.toJSON(value)).writeUtf8("\n");
        }
        catch (IOException ex) {
            throw new CurseException("Failed to write JSON: " + path, ex);
        }
    }
}

