/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.game;

import com.therandomlabs.curseapi.game.CurseGameVersionGroup;
import java.util.Objects;

public abstract class CurseGameVersion<V extends CurseGameVersion<?>>
implements Comparable<V> {
    public final int hashCode() {
        return Objects.hash(this.gameID(), this.versionString());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CurseGameVersion)) {
            return false;
        }
        CurseGameVersion version = (CurseGameVersion)object;
        return this.gameID() == version.gameID() && this.versionString().equals(version.versionString());
    }

    public String toString() {
        return this.versionString();
    }

    public CurseGameVersionGroup<V> versionGroup() {
        return CurseGameVersionGroup.none(this.gameID());
    }

    public final boolean newerThan(V version) {
        return this.compareTo(version) > 0;
    }

    public final boolean olderThan(V version) {
        return this.compareTo(version) < 0;
    }

    public abstract int gameID();

    public abstract String versionString();
}

