/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.forgesvc;

import com.therandomlabs.curseapi.CurseAPIProvider;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.file.CurseFile;
import com.therandomlabs.curseapi.file.CurseFiles;
import com.therandomlabs.curseapi.forgesvc.ForgeSvc;
import com.therandomlabs.curseapi.forgesvc.ForgeSvcCategory;
import com.therandomlabs.curseapi.forgesvc.ForgeSvcFile;
import com.therandomlabs.curseapi.forgesvc.ForgeSvcGame;
import com.therandomlabs.curseapi.forgesvc.ForgeSvcProject;
import com.therandomlabs.curseapi.game.CurseCategory;
import com.therandomlabs.curseapi.game.CurseGame;
import com.therandomlabs.curseapi.project.CurseProject;
import com.therandomlabs.curseapi.project.CurseSearchQuery;
import com.therandomlabs.curseapi.util.JsoupUtils;
import com.therandomlabs.curseapi.util.RetrofitUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import okhttp3.HttpUrl;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public final class ForgeSvcProvider
implements CurseAPIProvider {
    public static final ForgeSvcProvider instance = new ForgeSvcProvider();
    private static final ForgeSvc forgeSvc = RetrofitUtils.get("https://addons-ecs.forgesvc.net/").create(ForgeSvc.class);

    private ForgeSvcProvider() {
    }

    @Override
    public @Nullable CurseProject project(int id) throws CurseException {
        return RetrofitUtils.execute(forgeSvc.getProject(id));
    }

    @Override
    public @Nullable Element projectDescription(int id) throws CurseException {
        Element element = RetrofitUtils.getElement(forgeSvc.getDescription(id));
        return JsoupUtils.isEmpty(element) ? null : ForgeSvcProvider.replaceLinkouts(element);
    }

    @Override
    public List<CurseProject> searchProjects(CurseSearchQuery query) throws CurseException {
        List<ForgeSvcProject> projects = RetrofitUtils.execute(forgeSvc.searchProjects(query.gameID(), query.categorySectionID(), query.categoryID(), query.gameVersionString(), query.pageIndex(), query.pageSize(), query.searchFilter(), query.sortingMethod().id()));
        if (projects == null) {
            throw new CurseException("Failed to search projects: " + query);
        }
        return new ArrayList<CurseProject>(projects);
    }

    @Override
    public @Nullable CurseFiles<CurseFile> files(int projectID) throws CurseException {
        Set<ForgeSvcFile> files = RetrofitUtils.execute(forgeSvc.getFiles(projectID));
        if (files == null) {
            return null;
        }
        for (ForgeSvcFile file : files) {
            file.setProjectID(projectID);
        }
        return new CurseFiles<CurseFile>((Collection<CurseFile>)files);
    }

    @Override
    public @Nullable CurseFile file(int projectID, int fileID) throws CurseException {
        ForgeSvcFile file = RetrofitUtils.execute(forgeSvc.getFile(projectID, fileID));
        if (file == null) {
            return null;
        }
        file.setProjectID(projectID);
        return file;
    }

    @Override
    public @Nullable Element fileChangelog(int projectID, int fileID) throws CurseException {
        Element changelog = RetrofitUtils.getElement(forgeSvc.getChangelog(projectID, fileID));
        return changelog == null ? null : ForgeSvcProvider.replaceLinkouts(changelog);
    }

    @Override
    public @Nullable HttpUrl fileDownloadURL(int projectID, int fileID) throws CurseException {
        String url = RetrofitUtils.getString(forgeSvc.getFileDownloadURL(projectID, fileID));
        return url == null ? null : HttpUrl.get(url);
    }

    @Override
    public Set<CurseGame> games() throws CurseException {
        Set<ForgeSvcGame> games = RetrofitUtils.execute(forgeSvc.getGames(false));
        if (games == null) {
            throw new CurseException("Failed to retrieve games");
        }
        return new TreeSet<CurseGame>(games);
    }

    @Override
    public @Nullable CurseGame game(int id) throws CurseException {
        return RetrofitUtils.execute(forgeSvc.getGame(id));
    }

    @Override
    public Set<CurseCategory> categories() throws CurseException {
        Set<ForgeSvcCategory> categories = RetrofitUtils.execute(forgeSvc.getCategories());
        if (categories == null) {
            throw new CurseException("Failed to retrieve categories");
        }
        return new TreeSet<CurseCategory>(categories);
    }

    @Override
    public @Nullable Set<CurseCategory> categories(int sectionID) throws CurseException {
        Set<ForgeSvcCategory> categories = RetrofitUtils.execute(forgeSvc.getCategories(sectionID));
        return categories == null ? null : new TreeSet<ForgeSvcCategory>(categories);
    }

    @Override
    public @Nullable CurseCategory category(int id) throws CurseException {
        return RetrofitUtils.execute(forgeSvc.getCategory(id));
    }

    private static Element replaceLinkouts(Element element) {
        Elements links = element.getElementsByTag("a");
        for (Element link : links) {
            if (!link.attr("href").startsWith("/linkout?remoteUrl=")) continue;
            String encoded = link.attr("href").substring("/linkout?remoteUrl=".length());
            link.attr("href", ForgeSvcProvider.decode(ForgeSvcProvider.decode(encoded)));
        }
        return element;
    }

    private static String decode(String encoded) {
        try {
            return URLDecoder.decode(encoded.replace("+", "%2B"), StandardCharsets.UTF_8.name()).replace("%2B", "+");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

