/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.file;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.file.BasicCurseFile;
import com.therandomlabs.curseapi.file.CurseFile;
import com.therandomlabs.curseapi.file.CurseFileFilter;
import com.therandomlabs.curseapi.file.CurseFiles;
import com.therandomlabs.curseapi.project.CurseProject;
import com.therandomlabs.curseapi.util.CheckedFunction;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CurseFileChange<F extends BasicCurseFile> {
    private final F oldFile;
    private final F newFile;

    public CurseFileChange(F oldFile, F newFile) {
        Preconditions.checkNotNull(oldFile, "oldFile should not be null");
        Preconditions.checkNotNull(newFile, "newFile should not be null");
        Preconditions.checkArgument(((BasicCurseFile)oldFile).sameProject((BasicCurseFile)newFile), "oldFile and newFile should belong to the same project");
        Preconditions.checkArgument(!((BasicCurseFile)oldFile).equals(newFile), "oldFile and newFile should represent different files");
        this.oldFile = oldFile;
        this.newFile = newFile;
    }

    public final int hashCode() {
        return Objects.hash(this.oldFile, this.newFile);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CurseFileChange)) {
            return false;
        }
        CurseFileChange fileChange = (CurseFileChange)object;
        return ((BasicCurseFile)this.oldFile).equals(fileChange.oldFile) && ((BasicCurseFile)this.newFile).equals(fileChange.newFile);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("oldFile", this.oldFile).add("newFile", this.newFile).toString();
    }

    public int projectID() {
        return ((BasicCurseFile)this.oldFile).projectID();
    }

    public @Nullable CurseProject project() throws CurseException {
        return ((BasicCurseFile)this.oldFile).project();
    }

    public F oldFile() {
        return this.oldFile;
    }

    public @Nullable CurseFile oldCurseFile() throws CurseException {
        return this.asCurseFile(this.oldFile);
    }

    public F newFile() {
        return this.newFile;
    }

    public @Nullable CurseFile newCurseFile() throws CurseException {
        return this.asCurseFile(this.newFile);
    }

    public F olderFile() {
        return this.isDowngrade() ? this.newFile : this.oldFile;
    }

    public @Nullable CurseFile olderCurseFile() throws CurseException {
        return this.asCurseFile(this.olderFile());
    }

    public F newerFile() {
        return this.isDowngrade() ? this.oldFile : this.newFile;
    }

    public @Nullable CurseFile newerCurseFile() throws CurseException {
        return this.asCurseFile(this.newerFile());
    }

    public <T> @Nullable T get(CheckedFunction<? super CurseFile, ? extends T, CurseException> function) throws CurseException {
        CurseFile olderFile = this.olderCurseFile();
        if (olderFile != null) {
            return function.apply(olderFile);
        }
        CurseFile newerFile = this.newerCurseFile();
        if (newerFile != null) {
            return function.apply(newerFile);
        }
        throw new CurseException("Neither file for CurseFileChange could be retrieved as CurseFile: " + this);
    }

    public boolean isDowngrade() {
        return ((BasicCurseFile)this.oldFile).newerThan((BasicCurseFile)this.newFile);
    }

    public CurseFiles<CurseFile> filesBetween() throws CurseException {
        CurseProject project = this.project();
        if (project == null) {
            return new CurseFiles<CurseFile>();
        }
        CurseFiles<CurseFile> files = project.files();
        new CurseFileFilter().between(((BasicCurseFile)this.olderFile()).id(), ((BasicCurseFile)this.newerFile()).id() + 1).apply(files);
        return files;
    }

    public CurseFiles<CurseFile> filesBetweenInclusive() throws CurseException {
        CurseProject project = this.project();
        if (project == null) {
            return new CurseFiles<CurseFile>();
        }
        CurseFiles<CurseFile> files = project.files();
        new CurseFileFilter().between(((BasicCurseFile)this.olderFile()).id() - 1, ((BasicCurseFile)this.newerFile()).id() + 1).apply(files);
        return files;
    }

    private @Nullable CurseFile asCurseFile(F file) throws CurseException {
        if (file instanceof CurseFile) {
            return (CurseFile)file;
        }
        CurseProject project = this.project();
        return project == null ? null : project.files().fileWithID(((BasicCurseFile)file).id());
    }
}

