/*
 * Decompiled with CFR 0.152.
 */
package com.goxr3plus.fxborderlessscene.borderless;

import com.goxr3plus.fxborderlessscene.borderless.BorderlessController;
import com.goxr3plus.fxborderlessscene.borderless.BorderlessPane;
import com.goxr3plus.fxborderlessscene.borderless.Delta;
import java.io.IOException;
import javafx.beans.property.BooleanProperty;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class BorderlessScene
extends Scene {
    private BorderlessController controller;
    private BorderlessPane root;
    private Stage stage;

    public BorderlessScene(Stage stage, StageStyle stageStyle, Parent sceneRoot) {
        super((Parent)new Pane());
        try {
            this.controller = new BorderlessController();
            this.root = new BorderlessPane(this.controller);
            this.setRoot((Parent)this.root);
            this.setContent(sceneRoot);
            this.controller.setStage(stage);
            this.controller.createTransparentWindow(stage);
            stage.initStyle(stageStyle);
            if (stageStyle == StageStyle.UTILITY) {
                this.setSnapEnabled(false);
                this.setResizable(false);
            }
            this.stage = stage;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public BorderlessScene(Stage stage, StageStyle stageStyle, Parent sceneRoot, double minWidth, double minHeight) {
        this(stage, stageStyle, sceneRoot);
        stage.setMinWidth(minWidth);
        stage.setMinHeight(minHeight);
    }

    public void setContent(Parent content) {
        this.root.getChildren().remove(0);
        this.root.getChildren().add(0, (Object)content);
        AnchorPane.setLeftAnchor((Node)content, (Double)0.0);
        AnchorPane.setTopAnchor((Node)content, (Double)0.0);
        AnchorPane.setRightAnchor((Node)content, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)content, (Double)0.0);
    }

    public void setMoveControl(Node node) {
        this.controller.setMoveControl(node);
    }

    public void maximizeStage() {
        this.controller.maximize();
    }

    public void minimizeStage() {
        this.controller.minimize();
    }

    public void setResizable(boolean bool) {
        this.controller.setResizable(bool);
    }

    public void setSnapEnabled(boolean bool) {
        this.controller.setSnapEnabled(bool);
    }

    public BooleanProperty maximizedProperty() {
        return this.controller.maximizedProperty();
    }

    public BooleanProperty resizableProperty() {
        return this.controller.resizableProperty();
    }

    public BooleanProperty snapProperty() {
        return this.controller.snapProperty();
    }

    public boolean isMaximized() {
        return this.controller.maximizedProperty().get();
    }

    public boolean isResizable() {
        return this.controller.resizableProperty().get();
    }

    public boolean isSnapEnabled() {
        return this.controller.snapProperty().get();
    }

    public Delta getWindowedSize() {
        if (this.controller.prevSize.x == null) {
            this.controller.prevSize.x = this.stage.getWidth();
        }
        if (this.controller.prevSize.y == null) {
            this.controller.prevSize.y = this.stage.getHeight();
        }
        return this.controller.prevSize;
    }

    public Delta getWindowedPositon() {
        if (this.controller.prevPos.x == null) {
            this.controller.prevPos.x = this.stage.getX();
        }
        if (this.controller.prevPos.y == null) {
            this.controller.prevPos.y = this.stage.getY();
        }
        return this.controller.prevPos;
    }

    public void removeDefaultCSS() {
        this.root.getStylesheets().remove(0);
    }

    public void setTransparentWindowStyle(String style) {
        this.controller.getTransparentWindow().setStyle("");
        this.controller.getTransparentWindow().setStyle(style);
    }
}

